/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.vectors;

import org.apache.lucene.internal.hppc.IntIntHashMap;
import org.apache.lucene.search.AbstractKnnCollector;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.knn.KnnSearchStrategy;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitSet;

class DiversifyingNearestChildrenKnnCollector
extends AbstractKnnCollector {
    private final BitSet parentBitSet;
    private final NodeIdCachingHeap heap;

    DiversifyingNearestChildrenKnnCollector(int k, int visitLimit, KnnSearchStrategy searchStrategy, BitSet parentBitSet) {
        super(k, visitLimit, searchStrategy);
        this.parentBitSet = parentBitSet;
        this.heap = new NodeIdCachingHeap(k);
    }

    @Override
    public boolean collect(int docId, float nodeScore) {
        assert (!this.parentBitSet.get(docId));
        int parentNode = this.parentBitSet.nextSetBit(docId);
        return this.heap.insertWithOverflow(docId, parentNode, nodeScore);
    }

    @Override
    public float minCompetitiveSimilarity() {
        return this.heap.size >= this.k() ? this.heap.topScore() : Float.NEGATIVE_INFINITY;
    }

    public String toString() {
        return "ToParentJoinKnnCollector[k=" + this.k() + ", size=" + this.heap.size() + "]";
    }

    @Override
    public TopDocs topDocs() {
        assert (this.heap.size() <= this.k()) : "Tried to collect more results than the maximum number allowed";
        while (this.heap.size() > this.k()) {
            this.heap.popToDrain();
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[this.heap.size()];
        for (int i = 1; i <= scoreDocs.length; ++i) {
            scoreDocs[scoreDocs.length - i] = new ScoreDoc(this.heap.topNode(), this.heap.topScore());
            this.heap.popToDrain();
        }
        TotalHits.Relation relation = this.earlyTerminated() ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : TotalHits.Relation.EQUAL_TO;
        return new TopDocs(new TotalHits(this.visitedCount(), relation), scoreDocs);
    }

    @Override
    public int numCollected() {
        return this.heap.size();
    }

    private static class NodeIdCachingHeap {
        private final int maxSize;
        private ParentChildScore[] heapNodes;
        private int size = 0;
        private final IntIntHashMap nodeIdHeapIndex;
        private boolean closed = false;

        NodeIdCachingHeap(int maxSize) {
            if (maxSize < 1 || maxSize >= ArrayUtil.MAX_ARRAY_LENGTH) {
                throw new IllegalArgumentException("maxSize must be > 0 and < " + (ArrayUtil.MAX_ARRAY_LENGTH - 1) + "; got: " + maxSize);
            }
            int heapSize = maxSize + 1;
            this.maxSize = maxSize;
            this.nodeIdHeapIndex = new IntIntHashMap(maxSize);
            this.heapNodes = new ParentChildScore[heapSize];
        }

        public final int topNode() {
            return this.heapNodes[1].child;
        }

        public final float topScore() {
            return this.heapNodes[1].score;
        }

        private void pushIn(int nodeId, int parentId, float score) {
            ++this.size;
            if (this.size == this.heapNodes.length) {
                this.heapNodes = ArrayUtil.grow(this.heapNodes, (this.size * 3 + 1) / 2);
            }
            this.heapNodes[this.size] = new ParentChildScore(nodeId, parentId, score);
            this.upHeap(this.size);
        }

        private void updateElement(int heapIndex, int nodeId, int parentId, float score) {
            ParentChildScore oldValue = this.heapNodes[heapIndex];
            assert (oldValue.parent == parentId) : "attempted to update heap element value but with a different node id";
            float oldScore = this.heapNodes[heapIndex].score;
            this.heapNodes[heapIndex] = new ParentChildScore(nodeId, parentId, score);
            if (score < oldScore) {
                this.upHeap(heapIndex);
            } else {
                this.downHeap(heapIndex);
            }
        }

        public boolean insertWithOverflow(int node, int parentNode, float score) {
            if (this.closed) {
                throw new IllegalStateException();
            }
            int index = this.nodeIdHeapIndex.indexOf(parentNode);
            if (index >= 0) {
                int previousNodeIndex = this.nodeIdHeapIndex.indexGet(index);
                if (this.heapNodes[previousNodeIndex].score < score) {
                    this.updateElement(previousNodeIndex, node, parentNode, score);
                    return true;
                }
                return false;
            }
            if (this.size >= this.maxSize) {
                if (score < this.heapNodes[1].score || score == this.heapNodes[1].score && node > this.heapNodes[1].child) {
                    return false;
                }
                this.updateTop(node, parentNode, score);
                return true;
            }
            this.pushIn(node, parentNode, score);
            return true;
        }

        private void popToDrain() {
            this.closed = true;
            if (this.size > 0) {
                this.heapNodes[1] = this.heapNodes[this.size];
                --this.size;
            } else {
                throw new IllegalStateException("The heap is empty");
            }
            this.downHeapWithoutCacheUpdate(1);
        }

        private void updateTop(int nodeId, int parentId, float score) {
            this.nodeIdHeapIndex.remove(this.heapNodes[1].parent);
            this.heapNodes[1] = new ParentChildScore(nodeId, parentId, score);
            this.downHeap(1);
        }

        public final int size() {
            return this.size;
        }

        private void upHeap(int origPos) {
            int i = origPos;
            ParentChildScore bottomNode = this.heapNodes[i];
            for (int j = i >>> 1; j > 0 && bottomNode.compareTo(this.heapNodes[j]) < 0; j >>>= 1) {
                this.heapNodes[i] = this.heapNodes[j];
                this.nodeIdHeapIndex.put(this.heapNodes[i].parent, i);
                i = j;
            }
            this.nodeIdHeapIndex.put(bottomNode.parent, i);
            this.heapNodes[i] = bottomNode;
        }

        private void downHeap(int i) {
            ParentChildScore node = this.heapNodes[i];
            int j = i << 1;
            int k = j + 1;
            if (k <= this.size && this.heapNodes[k].compareTo(this.heapNodes[j]) < 0) {
                j = k;
            }
            while (j <= this.size && this.heapNodes[j].compareTo(node) < 0) {
                this.heapNodes[i] = this.heapNodes[j];
                this.nodeIdHeapIndex.put(this.heapNodes[i].parent, i);
                i = j;
                k = (j = i << 1) + 1;
                if (k > this.size || this.heapNodes[k].compareTo(this.heapNodes[j]) >= 0) continue;
                j = k;
            }
            this.nodeIdHeapIndex.put(node.parent, i);
            this.heapNodes[i] = node;
        }

        private void downHeapWithoutCacheUpdate(int i) {
            ParentChildScore node = this.heapNodes[i];
            int j = i << 1;
            int k = j + 1;
            if (k <= this.size && this.heapNodes[k].compareTo(this.heapNodes[j]) < 0) {
                j = k;
            }
            while (j <= this.size && this.heapNodes[j].compareTo(node) < 0) {
                this.heapNodes[i] = this.heapNodes[j];
                i = j;
                k = (j = i << 1) + 1;
                if (k > this.size || this.heapNodes[k].compareTo(this.heapNodes[j]) >= 0) continue;
                j = k;
            }
            this.heapNodes[i] = node;
        }
    }

    private record ParentChildScore(int child, int parent, float score) implements Comparable<ParentChildScore>
    {
        @Override
        public int compareTo(ParentChildScore o) {
            int fc = Float.compare(this.score, o.score);
            if (fc == 0) {
                return Integer.compare(o.child, this.child);
            }
            return fc;
        }
    }
}

