/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorReducer;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.Avg;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.InternalNumericMetricsAggregation;
import org.elasticsearch.search.aggregations.support.SamplingContext;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class InternalAvg
extends InternalNumericMetricsAggregation.SingleValue
implements Avg {
    private final double sum;
    private final long count;

    public InternalAvg(String name, double sum, long count, DocValueFormat format, Map<String, Object> metadata) {
        super(name, format, metadata);
        this.sum = sum;
        this.count = count;
    }

    public InternalAvg(StreamInput in) throws IOException {
        super(in);
        this.sum = in.readDouble();
        this.count = in.readVLong();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.format);
        out.writeDouble(this.sum);
        out.writeVLong(this.count);
    }

    public static InternalAvg empty(String name, DocValueFormat format, Map<String, Object> metadata) {
        return new InternalAvg(name, 0.0, 0L, format, metadata);
    }

    @Override
    public double value() {
        return this.getValue();
    }

    @Override
    public double getValue() {
        return this.sum / (double)this.count;
    }

    double getSum() {
        return this.sum;
    }

    long getCount() {
        return this.count;
    }

    DocValueFormat getFormatter() {
        return this.format;
    }

    @Override
    public String getWriteableName() {
        return "avg";
    }

    @Override
    protected AggregatorReducer getLeaderReducer(AggregationReduceContext reduceContext, int size) {
        return new AggregatorReducer(){
            long count = 0L;
            final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);

            @Override
            public void accept(InternalAggregation aggregation) {
                InternalAvg avg = (InternalAvg)aggregation;
                this.count += avg.count;
                this.kahanSummation.add(avg.sum);
            }

            @Override
            public InternalAggregation get() {
                return new InternalAvg(InternalAvg.this.getName(), this.kahanSummation.value(), this.count, InternalAvg.this.format, InternalAvg.this.getMetadata());
            }
        };
    }

    @Override
    public InternalAggregation finalizeSampling(SamplingContext samplingContext) {
        return this;
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Aggregation.CommonFields.VALUE.getPreferredName(), this.count != 0L ? Double.valueOf(this.getValue()) : null);
        if (this.count != 0L && this.format != DocValueFormat.RAW) {
            builder.field(Aggregation.CommonFields.VALUE_AS_STRING.getPreferredName(), this.format.format(this.getValue()).toString());
        }
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sum, this.count, this.format.getWriteableName());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalAvg other = (InternalAvg)obj;
        return Objects.equals(this.sum, other.sum) && Objects.equals(this.count, other.count) && Objects.equals(this.format.getWriteableName(), other.format.getWriteableName());
    }
}

