/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.transport.AbstractTransportRequest;

public class StartRecoveryRequest
extends AbstractTransportRequest {
    private final long recoveryId;
    private final ShardId shardId;
    private final String targetAllocationId;
    private final DiscoveryNode sourceNode;
    private final DiscoveryNode targetNode;
    private final long clusterStateVersion;
    private final Store.MetadataSnapshot metadataSnapshot;
    private final boolean primaryRelocation;
    private final long startingSeqNo;
    private final boolean canDownloadSnapshotFiles;

    public StartRecoveryRequest(StreamInput in) throws IOException {
        super(in);
        this.recoveryId = in.readLong();
        this.shardId = new ShardId(in);
        this.targetAllocationId = in.readString();
        this.sourceNode = new DiscoveryNode(in);
        this.targetNode = new DiscoveryNode(in);
        this.clusterStateVersion = in.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X) ? in.readVLong() : 0L;
        this.metadataSnapshot = Store.MetadataSnapshot.readFrom(in);
        this.primaryRelocation = in.readBoolean();
        this.startingSeqNo = in.readLong();
        this.canDownloadSnapshotFiles = in.readBoolean();
    }

    public StartRecoveryRequest(ShardId shardId, String targetAllocationId, DiscoveryNode sourceNode, DiscoveryNode targetNode, long clusterStateVersion, Store.MetadataSnapshot metadataSnapshot, boolean primaryRelocation, long recoveryId, long startingSeqNo, boolean canDownloadSnapshotFiles) {
        this.clusterStateVersion = clusterStateVersion;
        this.recoveryId = recoveryId;
        this.shardId = shardId;
        this.targetAllocationId = targetAllocationId;
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.metadataSnapshot = metadataSnapshot;
        this.primaryRelocation = primaryRelocation;
        this.startingSeqNo = startingSeqNo;
        this.canDownloadSnapshotFiles = canDownloadSnapshotFiles;
        assert (startingSeqNo == -2L || metadataSnapshot.getHistoryUUID() != null) : "starting seq no is set but not history uuid";
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public String targetAllocationId() {
        return this.targetAllocationId;
    }

    public DiscoveryNode sourceNode() {
        return this.sourceNode;
    }

    public DiscoveryNode targetNode() {
        return this.targetNode;
    }

    public long clusterStateVersion() {
        return this.clusterStateVersion;
    }

    public boolean isPrimaryRelocation() {
        return this.primaryRelocation;
    }

    public Store.MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    public long startingSeqNo() {
        return this.startingSeqNo;
    }

    public boolean canDownloadSnapshotFiles() {
        return this.canDownloadSnapshotFiles;
    }

    @Override
    public String getDescription() {
        return Strings.format("recovery of %s to %s [recoveryId=%d, targetAllocationId=%s, clusterStateVersion=%d, startingSeqNo=%d, primaryRelocation=%s, canDownloadSnapshotFiles=%s]", this.shardId, this.targetNode.descriptionWithoutAttributes(), this.recoveryId, this.targetAllocationId, this.clusterStateVersion, this.startingSeqNo, this.primaryRelocation, this.canDownloadSnapshotFiles);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
        out.writeString(this.targetAllocationId);
        this.sourceNode.writeTo(out);
        this.targetNode.writeTo(out);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_11_X)) {
            out.writeVLong(this.clusterStateVersion);
        }
        this.metadataSnapshot.writeTo(out);
        out.writeBoolean(this.primaryRelocation);
        out.writeLong(this.startingSeqNo);
        out.writeBoolean(this.canDownloadSnapshotFiles);
    }

    @Override
    public String toString() {
        return "StartRecoveryRequest{shardId=" + String.valueOf(this.shardId) + ", targetNode=" + this.targetNode.descriptionWithoutAttributes() + ", recoveryId=" + this.recoveryId + ", targetAllocationId='" + this.targetAllocationId + "', clusterStateVersion=" + this.clusterStateVersion + ", primaryRelocation=" + this.primaryRelocation + ", startingSeqNo=" + this.startingSeqNo + ", canDownloadSnapshotFiles=" + this.canDownloadSnapshotFiles + "}";
    }
}

