/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.broadcast.BaseBroadcastResponse;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;

public abstract class TransportBroadcastReplicationAction<Request extends BroadcastRequest<Request>, Response extends BaseBroadcastResponse, ShardRequest extends ReplicationRequest<ShardRequest>, ShardResponse extends ReplicationResponse>
extends HandledTransportAction<Request, Response> {
    private final ActionType<ShardResponse> replicatedBroadcastShardAction;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final NodeClient client;
    private final Executor executor;
    private final ProjectResolver projectResolver;

    public TransportBroadcastReplicationAction(String name, Writeable.Reader<Request> requestReader, ClusterService clusterService, TransportService transportService, NodeClient client, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ActionType<ShardResponse> replicatedBroadcastShardAction, Executor executor, ProjectResolver projectResolver) {
        super(name, transportService, actionFilters, requestReader, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
        this.replicatedBroadcastShardAction = replicatedBroadcastShardAction;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.executor = executor;
        this.projectResolver = projectResolver;
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        this.executor.execute(ActionRunnable.wrap(listener, this.createAsyncAction(task, request)));
    }

    private CheckedConsumer<ActionListener<Response>, Exception> createAsyncAction(Task task, Request request) {
        return new CheckedConsumer<ActionListener<Response>, Exception>(){
            private int totalShardCopyCount;
            private int successShardCopyCount;
            private final List<DefaultShardOperationFailedException> allFailures = new ArrayList<DefaultShardOperationFailedException>();
            final /* synthetic */ BroadcastRequest val$request;
            final /* synthetic */ Task val$task;
            {
                this.val$request = broadcastRequest;
                this.val$task = task;
            }

            @Override
            public void accept(ActionListener<Response> listener) {
                assert (this.totalShardCopyCount == 0 && this.successShardCopyCount == 0 && this.allFailures.isEmpty()) : "shouldn't call this twice";
                ClusterState clusterState = TransportBroadcastReplicationAction.this.clusterService.state();
                ProjectMetadata project = TransportBroadcastReplicationAction.this.projectResolver.getProjectMetadata(clusterState);
                List<ShardId> shards = TransportBroadcastReplicationAction.this.shards(this.val$request, project, clusterState.routingTable(project.id()));
                Map<String, IndexMetadata> indexMetadataByName = project.indices();
                try (RefCountingRunnable refs = new RefCountingRunnable(() -> this.finish(listener));){
                    for (ShardId shardId : shards) {
                        TransportBroadcastReplicationAction.this.shardExecute(this.val$task, this.val$request, shardId, ActionListener.releaseAfter(new ReplicationResponseActionListener(shardId, indexMetadataByName), refs.acquire()));
                    }
                }
            }

            private synchronized void addShardResponse(int numCopies, int successful, List<DefaultShardOperationFailedException> failures) {
                this.totalShardCopyCount += numCopies;
                this.successShardCopyCount += successful;
                this.allFailures.addAll(failures);
            }

            void finish(ActionListener<Response> listener) {
                TransportBroadcastReplicationAction.this.logger.trace("{}: got all shard responses", (Object)TransportBroadcastReplicationAction.this.actionName);
                listener.onResponse(TransportBroadcastReplicationAction.this.newResponse(this.successShardCopyCount, this.allFailures.size(), this.totalShardCopyCount, this.allFailures));
            }

            class ReplicationResponseActionListener
            implements ActionListener<ShardResponse> {
                private final ShardId shardId;
                private final Map<String, IndexMetadata> indexMetadataByName;

                ReplicationResponseActionListener(ShardId shardId, Map<String, IndexMetadata> indexMetadataByName) {
                    this.shardId = shardId;
                    this.indexMetadataByName = indexMetadataByName;
                }

                @Override
                public void onResponse(ShardResponse shardResponse) {
                    assert (shardResponse != null);
                    TransportBroadcastReplicationAction.this.logger.trace("{}: got response from {}", (Object)TransportBroadcastReplicationAction.this.actionName, (Object)this.shardId);
                    this.addShardResponse(((ReplicationResponse)shardResponse).getShardInfo().getTotal(), ((ReplicationResponse)shardResponse).getShardInfo().getSuccessful(), Arrays.stream(((ReplicationResponse)shardResponse).getShardInfo().getFailures()).map((? super T f) -> new DefaultShardOperationFailedException(new BroadcastShardOperationFailedException(this.shardId, f.getCause()))).toList());
                }

                @Override
                public void onFailure(Exception e) {
                    List<Object> result;
                    TransportBroadcastReplicationAction.this.logger.trace("{}: got failure from {}", (Object)TransportBroadcastReplicationAction.this.actionName, (Object)this.shardId);
                    int numCopies = this.indexMetadataByName.get(this.shardId.getIndexName()).getNumberOfReplicas() + 1;
                    if (TransportActions.isShardNotAvailableException(e)) {
                        result = List.of();
                    } else {
                        Object[] failures = new DefaultShardOperationFailedException[numCopies];
                        Arrays.fill(failures, new DefaultShardOperationFailedException(new BroadcastShardOperationFailedException(this.shardId, (Throwable)e)));
                        result = Arrays.asList(failures);
                    }
                    this.addShardResponse(numCopies, 0, result);
                }
            }
        };
    }

    protected void shardExecute(Task task, Request request, ShardId shardId, ActionListener<ShardResponse> shardActionListener) {
        assert (Transports.assertNotTransportThread("may hit all the shards"));
        ShardRequest shardRequest = this.newShardRequest(request, shardId);
        shardRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
        this.client.executeLocally(this.replicatedBroadcastShardAction, shardRequest, shardActionListener);
    }

    protected List<ShardId> shards(Request request, ProjectMetadata project, RoutingTable indexRoutingTables) {
        String[] concreteIndices;
        assert (Transports.assertNotTransportThread("may hit all the shards"));
        ArrayList<ShardId> shardIds = new ArrayList<ShardId>();
        for (String index : concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(project, (IndicesRequest)request)) {
            IndexMetadata indexMetadata = project.indices().get(index);
            if (indexMetadata == null) continue;
            IndexRoutingTable indexRoutingTable = indexRoutingTables.indicesRouting().get(index);
            for (int i = 0; i < indexRoutingTable.size(); ++i) {
                shardIds.add(indexRoutingTable.shard(i).shardId());
            }
        }
        return shardIds;
    }

    protected abstract ShardRequest newShardRequest(Request var1, ShardId var2);

    protected abstract Response newResponse(int var1, int var2, int var3, List<DefaultShardOperationFailedException> var4);
}

