/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.AllField;
import co.elastic.clients.elasticsearch._types.mapping.DataStreamTimestamp;
import co.elastic.clients.elasticsearch._types.mapping.DynamicMapping;
import co.elastic.clients.elasticsearch._types.mapping.DynamicTemplate;
import co.elastic.clients.elasticsearch._types.mapping.FieldNamesField;
import co.elastic.clients.elasticsearch._types.mapping.IndexField;
import co.elastic.clients.elasticsearch._types.mapping.Property;
import co.elastic.clients.elasticsearch._types.mapping.RoutingField;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.mapping.SizeField;
import co.elastic.clients.elasticsearch._types.mapping.SourceField;
import co.elastic.clients.elasticsearch._types.mapping.Subobjects;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.NamedValue;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TypeMapping
implements JsonpSerializable {
    @Nullable
    private final AllField allField;
    @Nullable
    private final Boolean dateDetection;
    @Nullable
    private final DynamicMapping dynamic;
    private final List<String> dynamicDateFormats;
    private final List<NamedValue<DynamicTemplate>> dynamicTemplates;
    @Nullable
    private final FieldNamesField fieldNames;
    @Nullable
    private final IndexField indexField;
    private final Map<String, JsonData> meta;
    @Nullable
    private final Boolean numericDetection;
    private final Map<String, Property> properties;
    @Nullable
    private final RoutingField routing;
    @Nullable
    private final SizeField size;
    @Nullable
    private final SourceField source;
    private final Map<String, RuntimeField> runtime;
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final Subobjects subobjects;
    @Nullable
    private final DataStreamTimestamp dataStreamTimestamp;
    public static final JsonpDeserializer<TypeMapping> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TypeMapping::setupTypeMappingDeserializer);

    private TypeMapping(Builder builder) {
        this.allField = builder.allField;
        this.dateDetection = builder.dateDetection;
        this.dynamic = builder.dynamic;
        this.dynamicDateFormats = ApiTypeHelper.unmodifiable(builder.dynamicDateFormats);
        this.dynamicTemplates = ApiTypeHelper.unmodifiable(builder.dynamicTemplates);
        this.fieldNames = builder.fieldNames;
        this.indexField = builder.indexField;
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.numericDetection = builder.numericDetection;
        this.properties = ApiTypeHelper.unmodifiable(builder.properties);
        this.routing = builder.routing;
        this.size = builder.size;
        this.source = builder.source;
        this.runtime = ApiTypeHelper.unmodifiable(builder.runtime);
        this.enabled = builder.enabled;
        this.subobjects = builder.subobjects;
        this.dataStreamTimestamp = builder.dataStreamTimestamp;
    }

    public static TypeMapping of(Function<Builder, ObjectBuilder<TypeMapping>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final AllField allField() {
        return this.allField;
    }

    @Nullable
    public final Boolean dateDetection() {
        return this.dateDetection;
    }

    @Nullable
    public final DynamicMapping dynamic() {
        return this.dynamic;
    }

    public final List<String> dynamicDateFormats() {
        return this.dynamicDateFormats;
    }

    public final List<NamedValue<DynamicTemplate>> dynamicTemplates() {
        return this.dynamicTemplates;
    }

    @Nullable
    public final FieldNamesField fieldNames() {
        return this.fieldNames;
    }

    @Nullable
    public final IndexField indexField() {
        return this.indexField;
    }

    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nullable
    public final Boolean numericDetection() {
        return this.numericDetection;
    }

    public final Map<String, Property> properties() {
        return this.properties;
    }

    @Nullable
    public final RoutingField routing() {
        return this.routing;
    }

    @Nullable
    public final SizeField size() {
        return this.size;
    }

    @Nullable
    public final SourceField source() {
        return this.source;
    }

    public final Map<String, RuntimeField> runtime() {
        return this.runtime;
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public final Subobjects subobjects() {
        return this.subobjects;
    }

    @Nullable
    public final DataStreamTimestamp dataStreamTimestamp() {
        return this.dataStreamTimestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allField != null) {
            generator.writeKey("all_field");
            this.allField.serialize(generator, mapper);
        }
        if (this.dateDetection != null) {
            generator.writeKey("date_detection");
            generator.write(this.dateDetection);
        }
        if (this.dynamic != null) {
            generator.writeKey("dynamic");
            this.dynamic.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.dynamicDateFormats)) {
            generator.writeKey("dynamic_date_formats");
            generator.writeStartArray();
            for (String string : this.dynamicDateFormats) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.dynamicTemplates)) {
            generator.writeKey("dynamic_templates");
            generator.writeStartArray();
            for (NamedValue namedValue : this.dynamicTemplates) {
                generator.writeStartObject();
                generator.writeKey(namedValue.name());
                ((DynamicTemplate)namedValue.value()).serialize(generator, mapper);
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        if (this.fieldNames != null) {
            generator.writeKey("_field_names");
            this.fieldNames.serialize(generator, mapper);
        }
        if (this.indexField != null) {
            generator.writeKey("index_field");
            this.indexField.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.numericDetection != null) {
            generator.writeKey("numeric_detection");
            generator.write(this.numericDetection);
        }
        if (ApiTypeHelper.isDefined(this.properties)) {
            generator.writeKey("properties");
            generator.writeStartObject();
            for (Map.Entry entry : this.properties.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((Property)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.routing != null) {
            generator.writeKey("_routing");
            this.routing.serialize(generator, mapper);
        }
        if (this.size != null) {
            generator.writeKey("_size");
            this.size.serialize(generator, mapper);
        }
        if (this.source != null) {
            generator.writeKey("_source");
            this.source.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.runtime)) {
            generator.writeKey("runtime");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtime.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RuntimeField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled);
        }
        if (this.subobjects != null) {
            generator.writeKey("subobjects");
            this.subobjects.serialize(generator, mapper);
        }
        if (this.dataStreamTimestamp != null) {
            generator.writeKey("_data_stream_timestamp");
            this.dataStreamTimestamp.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTypeMappingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allField, AllField._DESERIALIZER, "all_field");
        op.add(Builder::dateDetection, JsonpDeserializer.booleanDeserializer(), "date_detection");
        op.add(Builder::dynamic, DynamicMapping._DESERIALIZER, "dynamic");
        op.add(Builder::dynamicDateFormats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "dynamic_date_formats");
        op.add(Builder::dynamicTemplates, JsonpDeserializer.arrayDeserializer(NamedValue.deserializer(() -> DynamicTemplate._DESERIALIZER)), "dynamic_templates");
        op.add(Builder::fieldNames, FieldNamesField._DESERIALIZER, "_field_names");
        op.add(Builder::indexField, IndexField._DESERIALIZER, "index_field");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::numericDetection, JsonpDeserializer.booleanDeserializer(), "numeric_detection");
        op.add(Builder::properties, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "properties");
        op.add(Builder::routing, RoutingField._DESERIALIZER, "_routing");
        op.add(Builder::size, SizeField._DESERIALIZER, "_size");
        op.add(Builder::source, SourceField._DESERIALIZER, "_source");
        op.add(Builder::runtime, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime");
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::subobjects, Subobjects._DESERIALIZER, "subobjects");
        op.add(Builder::dataStreamTimestamp, DataStreamTimestamp._DESERIALIZER, "_data_stream_timestamp");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TypeMapping> {
        @Nullable
        private AllField allField;
        @Nullable
        private Boolean dateDetection;
        @Nullable
        private DynamicMapping dynamic;
        @Nullable
        private List<String> dynamicDateFormats;
        @Nullable
        private List<NamedValue<DynamicTemplate>> dynamicTemplates;
        @Nullable
        private FieldNamesField fieldNames;
        @Nullable
        private IndexField indexField;
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private Boolean numericDetection;
        @Nullable
        private Map<String, Property> properties;
        @Nullable
        private RoutingField routing;
        @Nullable
        private SizeField size;
        @Nullable
        private SourceField source;
        @Nullable
        private Map<String, RuntimeField> runtime;
        @Nullable
        private Boolean enabled;
        @Nullable
        private Subobjects subobjects;
        @Nullable
        private DataStreamTimestamp dataStreamTimestamp;

        public final Builder allField(@Nullable AllField value) {
            this.allField = value;
            return this;
        }

        public final Builder allField(Function<AllField.Builder, ObjectBuilder<AllField>> fn) {
            return this.allField(fn.apply(new AllField.Builder()).build());
        }

        public final Builder dateDetection(@Nullable Boolean value) {
            this.dateDetection = value;
            return this;
        }

        public final Builder dynamic(@Nullable DynamicMapping value) {
            this.dynamic = value;
            return this;
        }

        public final Builder dynamicDateFormats(List<String> list) {
            this.dynamicDateFormats = Builder._listAddAll(this.dynamicDateFormats, list);
            return this;
        }

        public final Builder dynamicDateFormats(String value, String ... values) {
            this.dynamicDateFormats = Builder._listAdd(this.dynamicDateFormats, value, values);
            return this;
        }

        public final Builder dynamicTemplates(List<NamedValue<DynamicTemplate>> list) {
            this.dynamicTemplates = Builder._listAddAll(this.dynamicTemplates, list);
            return this;
        }

        public final Builder dynamicTemplates(NamedValue<DynamicTemplate> value, NamedValue<DynamicTemplate> ... values) {
            this.dynamicTemplates = Builder._listAdd(this.dynamicTemplates, value, values);
            return this;
        }

        public final Builder fieldNames(@Nullable FieldNamesField value) {
            this.fieldNames = value;
            return this;
        }

        public final Builder fieldNames(Function<FieldNamesField.Builder, ObjectBuilder<FieldNamesField>> fn) {
            return this.fieldNames(fn.apply(new FieldNamesField.Builder()).build());
        }

        public final Builder indexField(@Nullable IndexField value) {
            this.indexField = value;
            return this;
        }

        public final Builder indexField(Function<IndexField.Builder, ObjectBuilder<IndexField>> fn) {
            return this.indexField(fn.apply(new IndexField.Builder()).build());
        }

        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        public final Builder numericDetection(@Nullable Boolean value) {
            this.numericDetection = value;
            return this;
        }

        public final Builder properties(Map<String, Property> map) {
            this.properties = Builder._mapPutAll(this.properties, map);
            return this;
        }

        public final Builder properties(String key, Property value) {
            this.properties = Builder._mapPut(this.properties, key, value);
            return this;
        }

        public final Builder properties(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.properties(key, fn.apply(new Property.Builder()).build());
        }

        public final Builder routing(@Nullable RoutingField value) {
            this.routing = value;
            return this;
        }

        public final Builder routing(Function<RoutingField.Builder, ObjectBuilder<RoutingField>> fn) {
            return this.routing(fn.apply(new RoutingField.Builder()).build());
        }

        public final Builder size(@Nullable SizeField value) {
            this.size = value;
            return this;
        }

        public final Builder size(Function<SizeField.Builder, ObjectBuilder<SizeField>> fn) {
            return this.size(fn.apply(new SizeField.Builder()).build());
        }

        public final Builder source(@Nullable SourceField value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<SourceField.Builder, ObjectBuilder<SourceField>> fn) {
            return this.source(fn.apply(new SourceField.Builder()).build());
        }

        public final Builder runtime(Map<String, RuntimeField> map) {
            this.runtime = Builder._mapPutAll(this.runtime, map);
            return this;
        }

        public final Builder runtime(String key, RuntimeField value) {
            this.runtime = Builder._mapPut(this.runtime, key, value);
            return this;
        }

        public final Builder runtime(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtime(key, fn.apply(new RuntimeField.Builder()).build());
        }

        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder subobjects(@Nullable Subobjects value) {
            this.subobjects = value;
            return this;
        }

        public final Builder dataStreamTimestamp(@Nullable DataStreamTimestamp value) {
            this.dataStreamTimestamp = value;
            return this;
        }

        public final Builder dataStreamTimestamp(Function<DataStreamTimestamp.Builder, ObjectBuilder<DataStreamTimestamp>> fn) {
            return this.dataStreamTimestamp(fn.apply(new DataStreamTimestamp.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TypeMapping build() {
            this._checkSingleUse();
            return new TypeMapping(this);
        }
    }
}

