"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectionEnginePage = void 0;
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/timelines-plugin/public");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _lodash = require("lodash");
var _use_data_view = require("../../../data_view_manager/hooks/use_data_view");
var _use_group_take_action_items = require("../../hooks/alerts_table/use_group_take_action_items");
var _grouping_settings = require("../../components/alerts_table/grouping_settings");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _detection_engine_filters = require("../../components/detection_engine_filters/detection_engine_filters");
var _filter_by_assignees_popover = require("../../../common/components/filter_by_assignees_popover/filter_by_assignees_popover");
var _use_data_table_filters = require("../../../common/hooks/use_data_table_filters");
var _constants = require("../../../common/store/inputs/constants");
var _use_selector = require("../../../common/hooks/use_selector");
var _types = require("../../../app/types");
var _use_global_time = require("../../../common/containers/use_global_time");
var _filters_global = require("../../../common/components/filters_global");
var _redirect_to_detection_engine = require("../../../common/components/link_to/redirect_to_detection_engine");
var _search_bar = require("../../../common/components/search_bar");
var _page_wrapper = require("../../../common/components/page_wrapper");
var _inputs = require("../../../common/store/inputs");
var _actions = require("../../../common/store/inputs/actions");
var _no_api_integration_callout = require("../../components/callouts/no_api_integration_callout");
var _user_info = require("../../components/user_info");
var _detection_engine_no_index = require("./detection_engine_no_index");
var _use_lists_config = require("../../containers/detection_engine/lists/use_lists_config");
var _detection_engine_user_unauthenticated = require("./detection_engine_user_unauthenticated");
var i18n = _interopRequireWildcard(require("./translations"));
var _links = require("../../../common/components/links");
var _link_to = require("../../../common/components/link_to");
var _use_full_screen = require("../../../common/containers/use_full_screen");
var _display = require("../../../explore/hosts/pages/display");
var _helpers = require("../../../timelines/components/timeline/helpers");
var _default_config = require("../../components/alerts_table/default_config");
var _chart_panels = require("../../components/alerts_kpis/chart_panels");
var _containers = require("../../../sourcerer/containers");
var _use_signal_helpers = require("../../../sourcerer/containers/use_signal_helpers");
var _model = require("../../../sourcerer/store/model");
var _need_admin_for_update_callout = require("../../components/callouts/need_admin_for_update_callout");
var _missing_privileges_callout = require("../../components/callouts/missing_privileges_callout");
var _kibana = require("../../../common/lib/kibana");
var _no_privileges = require("../../../common/components/no_privileges");
var _header_page = require("../../../common/components/header_page");
var _empty_prompt = require("../../../common/components/empty_prompt");
var _alerts_grouping = require("../../components/alerts_table/alerts_grouping");
var _alerts_table = require("../../components/alerts_table");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// No bueno, I know! Encountered when reverting RBAC work post initial BCs
// Don't want to include large amounts of refactor in this temporary workaround
// TODO: Refactor code - component can be broken apart

/**
 * Need a 100% height here to account for the graph/analyze tool, which sets no explicit height parameters, but fills the available space.
 */
const StyledFullHeightContainer = _styled.default.div`
  display: flex;
  flex-direction: column;
  flex: 1 1 auto;
`;
const DetectionEnginePageComponent = () => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const containerElement = (0, _react.useRef)(null);
  const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
  const isTableLoading = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTable;
    return ((_getTable = getTable(state, _securitysolutionDataTable.TableId.alertsOnAlertsPage)) !== null && _getTable !== void 0 ? _getTable : _securitysolutionDataTable.tableDefaults).isLoading;
  });
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _inputs.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const filters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const [{
    loading: userInfoLoading,
    isAuthenticated: isUserAuthenticated,
    hasEncryptionKey,
    signalIndexName,
    canUserREAD,
    hasIndexRead,
    hasIndexWrite,
    hasIndexMaintenance
  }] = (0, _user_info.useUserData)();
  const {
    loading: listsConfigLoading,
    needsConfiguration: needsListsConfiguration
  } = (0, _use_lists_config.useListsConfig)();
  const [assignees, setAssignees] = (0, _react.useState)([]);
  const handleSelectedAssignees = (0, _react.useCallback)(newAssignees => {
    if (!(0, _lodash.isEqual)(newAssignees, assignees)) {
      setAssignees(newAssignees);
    }
  }, [assignees]);
  const [statusFilter, setStatusFilter] = (0, _react.useState)([]);
  const [detectionPageFilters, setDetectionPageFilters] = (0, _react.useState)();
  const [detectionPageFilterHandler, setDetectionPageFilterHandler] = (0, _react.useState)();
  const {
    sourcererDataView: oldSourcererDataViewSpec,
    loading: oldIsLoadingIndexPattern
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.detections);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView,
    status: experimentalDataViewStatus
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.detections);
  const runtimeMappings = (0, _react.useMemo)(() => {
    var _ref, _ref2;
    return newDataViewPickerEnabled ? (_ref = experimentalDataView.getRuntimeMappings()) !== null && _ref !== void 0 ? _ref : {} : (_ref2 = oldSourcererDataViewSpec.runtimeFieldMap) !== null && _ref2 !== void 0 ? _ref2 : {};
  }, [newDataViewPickerEnabled, experimentalDataView, oldSourcererDataViewSpec.runtimeFieldMap]);
  const isLoadingIndexPattern = newDataViewPickerEnabled ? experimentalDataViewStatus !== 'ready' : oldIsLoadingIndexPattern;
  const {
    formatUrl
  } = (0, _link_to.useFormatUrl)(_types.SecurityPageName.rules);
  const {
    showBuildingBlockAlerts,
    showOnlyThreatIndicatorAlerts
  } = (0, _use_data_table_filters.useDataTableFilters)(_securitysolutionDataTable.TableId.alertsOnAlertsPage);
  const loading = userInfoLoading || listsConfigLoading;
  const {
    application: {
      navigateToUrl
    },
    data
  } = (0, _kibana.useKibana)().services;
  const {
    filterManager
  } = data.query;
  const topLevelFilters = (0, _react.useMemo)(() => {
    return [...filters, ...(0, _default_config.buildShowBuildingBlockFilter)(showBuildingBlockAlerts), ...(0, _default_config.buildThreatMatchFilter)(showOnlyThreatIndicatorAlerts), ...(0, _default_config.buildAlertAssigneesFilter)(assignees)];
  }, [assignees, showBuildingBlockAlerts, showOnlyThreatIndicatorAlerts, filters]);
  (0, _react.useEffect)(() => {
    if (!detectionPageFilterHandler) return;
    // if Alert is reloaded because of action by the user.
    // We want reload the values in the detection Page filters
    if (!isTableLoading) detectionPageFilterHandler.reload();
  }, [isTableLoading, detectionPageFilterHandler]);
  const addFilter = (0, _react.useCallback)(({
    field,
    value,
    negate
  }) => {
    filterManager.addFilters([{
      meta: {
        alias: null,
        disabled: false,
        negate: negate !== null && negate !== void 0 ? negate : false
      },
      ...(value != null ? {
        query: {
          match_phrase: {
            [field]: value
          }
        }
      } : {
        exists: {
          field
        }
      })
    }]);
  }, [filterManager]);
  const updateDateRangeCallback = (0, _react.useCallback)(({
    x
  }) => {
    if (!x) {
      return;
    }
    const [min, max] = x;
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: _constants.InputsModelId.global,
      from: new Date(min).toISOString(),
      to: new Date(max).toISOString()
    }));
  }, [dispatch]);
  const goToRules = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToUrl(formatUrl((0, _redirect_to_detection_engine.getRulesUrl)()));
  }, [formatUrl, navigateToUrl]);
  const alertsDefaultFilters = (0, _react.useMemo)(() => [...topLevelFilters, ...(detectionPageFilters !== null && detectionPageFilters !== void 0 ? detectionPageFilters : [])], [topLevelFilters, detectionPageFilters]);

  // AlertsTable manages global filters itself, so not including `filters`
  const alertsTableDefaultFilters = (0, _react.useMemo)(() => [...(0, _default_config.buildShowBuildingBlockFilter)(showBuildingBlockAlerts), ...(0, _default_config.buildThreatMatchFilter)(showOnlyThreatIndicatorAlerts), ...(detectionPageFilters !== null && detectionPageFilters !== void 0 ? detectionPageFilters : []), ...(0, _default_config.buildAlertAssigneesFilter)(assignees)], [assignees, showBuildingBlockAlerts, showOnlyThreatIndicatorAlerts, detectionPageFilters]);
  const {
    signalIndexNeedsInit,
    pollForSignalIndex
  } = (0, _use_signal_helpers.useSignalHelpers)();
  const onSkipFocusBeforeEventsTable = (0, _react.useCallback)(() => {
    (0, _helpers.focusUtilityBarAction)(containerElement.current);
  }, [containerElement]);
  const onSkipFocusAfterEventsTable = (0, _react.useCallback)(() => {
    (0, _helpers.resetKeyboardFocus)();
  }, []);
  const onKeyDown = (0, _react.useCallback)(keyboardEvent => {
    if ((0, _public.isTab)(keyboardEvent)) {
      (0, _helpers.onTimelineTabKeyPressed)({
        containerElement: containerElement.current,
        keyboardEvent,
        onSkipFocusBeforeEventsTable,
        onSkipFocusAfterEventsTable
      });
    }
  }, [containerElement, onSkipFocusBeforeEventsTable, onSkipFocusAfterEventsTable]);
  const onFilterControlsChange = (0, _react.useCallback)(newFilters => {
    setDetectionPageFilters(newFilters);
    if (newFilters.length) {
      const newStatusFilter = newFilters.find(filter => filter.meta.key === 'kibana.alert.workflow_status');
      if (newStatusFilter) {
        var _newStatusFilter$quer;
        const status = newStatusFilter.meta.params ? newStatusFilter.meta.params : [(_newStatusFilter$quer = newStatusFilter.query) === null || _newStatusFilter$quer === void 0 ? void 0 : _newStatusFilter$quer.match_phrase['kibana.alert.workflow_status']];
        setStatusFilter(status);
      } else {
        setStatusFilter([]);
      }
    }
  }, []);
  const areDetectionPageFiltersLoading = (0, _react.useMemo)(() => !Array.isArray(detectionPageFilters), [detectionPageFilters]);
  const isAlertTableLoading = (0, _react.useMemo)(() => loading || areDetectionPageFiltersLoading, [loading, areDetectionPageFiltersLoading]);
  const isChartPanelLoading = (0, _react.useMemo)(() => isLoadingIndexPattern || areDetectionPageFiltersLoading, [isLoadingIndexPattern, areDetectionPageFiltersLoading]);
  const pageFiltersTimerange = (0, _react.useMemo)(() => ({
    from,
    to,
    mode: 'absolute'
  }), [from, to]);
  const renderAlertTable = (0, _react.useCallback)(groupingFilters => {
    return /*#__PURE__*/_react.default.createElement(_alerts_table.DetectionEngineAlertsTable, {
      tableType: _securitysolutionDataTable.TableId.alertsOnAlertsPage,
      inputFilters: [...alertsTableDefaultFilters, ...groupingFilters],
      isLoading: isAlertTableLoading,
      disableAdditionalToolbarControls: !!groupingFilters.length
    });
  }, [alertsTableDefaultFilters, isAlertTableLoading]);
  const groupTakeActionItems = (0, _use_group_take_action_items.useGroupTakeActionsItems)({
    currentStatus: statusFilter,
    showAlertStatusActions: Boolean(hasIndexWrite) && Boolean(hasIndexMaintenance)
  });
  const accordionExtraActionGroupStats = (0, _react.useMemo)(() => ({
    aggregations: _grouping_settings.defaultGroupStatsAggregations,
    renderer: _grouping_settings.defaultGroupStatsRenderer
  }), []);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
      border: true,
      title: i18n.PAGE_TITLE,
      isLoading: loading
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl"
    })));
  }
  if (isUserAuthenticated != null && !isUserAuthenticated && !loading) {
    return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
      border: true,
      title: i18n.PAGE_TITLE
    }), /*#__PURE__*/_react.default.createElement(_detection_engine_user_unauthenticated.DetectionEngineUserUnauthenticated, null));
  }
  if (!loading && signalIndexNeedsInit || needsListsConfiguration) {
    return /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, null, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
      border: true,
      title: i18n.PAGE_TITLE
    }), /*#__PURE__*/_react.default.createElement(_detection_engine_no_index.DetectionEngineNoIndex, {
      needsSignalsIndex: signalIndexNeedsInit,
      needsListsIndex: needsListsConfiguration
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasEncryptionKey != null && !hasEncryptionKey && /*#__PURE__*/_react.default.createElement(_no_api_integration_callout.NoApiIntegrationKeyCallOut, null), /*#__PURE__*/_react.default.createElement(_need_admin_for_update_callout.NeedAdminForUpdateRulesCallOut, null), /*#__PURE__*/_react.default.createElement(_missing_privileges_callout.MissingPrivilegesCallOut, null), !signalIndexNeedsInit && (hasIndexRead === false || canUserREAD === false) ? /*#__PURE__*/_react.default.createElement(_no_privileges.NoPrivileges, {
    pageName: i18n.PAGE_TITLE.toLowerCase(),
    docLinkSelector: docLinks => docLinks.siem.privileges
  }) : !signalIndexNeedsInit && hasIndexRead && canUserREAD ? /*#__PURE__*/_react.default.createElement(StyledFullHeightContainer, {
    onKeyDown: onKeyDown,
    ref: containerElement
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "resize",
    handler: _fp.noop
  }), /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, null, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    id: _constants.InputsModelId.global,
    pollForSignalIndex: pollForSignalIndex,
    sourcererDataView: oldSourcererDataViewSpec // TODO: newDataViewPicker -   Can be removed after migration to new dataview picker
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: globalFullScreen,
    "data-test-subj": "detectionsAlertsPage"
  }, /*#__PURE__*/_react.default.createElement(_display.Display, {
    show: !globalFullScreen
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: i18n.PAGE_TITLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_filter_by_assignees_popover.FilterByAssigneesPopover, {
    selectedUserIds: assignees,
    onSelectionChange: handleSelectedAssignees
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
    onClick: goToRules,
    deepLinkId: _types.SecurityPageName.rules,
    "data-test-subj": "manage-alert-detection-rules",
    fill: true
  }, i18n.BUTTON_MANAGE_RULES)))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_detection_engine_filters.DetectionEngineFilters, {
    filters: topLevelFilters,
    onFiltersChange: onFilterControlsChange,
    query: query,
    timeRange: pageFiltersTimerange,
    onInit: setDetectionPageFilterHandler,
    dataView: newDataViewPickerEnabled ? experimentalDataView : oldSourcererDataViewSpec
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_chart_panels.ChartPanels, {
    addFilter: addFilter,
    alertsDefaultFilters: alertsDefaultFilters,
    isLoadingIndexPattern: isChartPanelLoading,
    query: query,
    runtimeMappings: runtimeMappings,
    signalIndexName: signalIndexName,
    updateDateRangeCallback: updateDateRangeCallback
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_alerts_grouping.GroupedAlertsTable, {
    accordionButtonContent: _grouping_settings.defaultGroupTitleRenderers,
    accordionExtraActionGroupStats: accordionExtraActionGroupStats,
    dataView: experimentalDataView,
    dataViewSpec: oldSourcererDataViewSpec // TODO: Should be removed after migrating to new data view picker
    ,
    defaultFilters: alertsTableDefaultFilters,
    defaultGroupingOptions: _grouping_settings.defaultGroupingOptions,
    from: from,
    globalFilters: filters,
    globalQuery: query,
    groupTakeActionItems: groupTakeActionItems,
    loading: isAlertTableLoading,
    renderChildComponent: renderAlertTable,
    tableId: _securitysolutionDataTable.TableId.alertsOnAlertsPage,
    to: to
  }))) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, null));
};
const mapDispatchToProps = dispatch => ({
  clearSelected: ({
    id
  }) => dispatch(_securitysolutionDataTable.dataTableActions.clearSelected({
    id
  })),
  clearEventsLoading: ({
    id
  }) => dispatch(_securitysolutionDataTable.dataTableActions.clearEventsLoading({
    id
  })),
  clearEventsDeleted: ({
    id
  }) => dispatch(_securitysolutionDataTable.dataTableActions.clearEventsDeleted({
    id
  }))
});
const connector = (0, _reactRedux.connect)(null, mapDispatchToProps);
const DetectionEnginePage = exports.DetectionEnginePage = connector(/*#__PURE__*/_react.default.memo(DetectionEnginePageComponent));