"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoApiIntegrationKeyCallOut = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoApiIntegrationKeyCallOutComponent = () => {
  const [showCallOut, setShowCallOut] = (0, _react.useState)(true);
  const handleCallOut = (0, _react.useCallback)(() => setShowCallOut(false), [setShowCallOut]);
  return showCallOut ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.NO_API_INTEGRATION_KEY_CALLOUT_TITLE,
    color: "danger",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.NO_API_INTEGRATION_KEY_CALLOUT_MSG), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    onClick: handleCallOut
  }, i18n.DISMISS_CALLOUT)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })) : null;
};
const NoApiIntegrationKeyCallOut = exports.NoApiIntegrationKeyCallOut = /*#__PURE__*/(0, _react.memo)(NoApiIntegrationKeyCallOutComponent);