"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOsqueryEnabled = void 0;
var _kibana = require("../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useOsqueryEnabled = () => {
  const {
    osquery
  } = (0, _kibana.useKibana)().services;
  const osqueryStatus = osquery === null || osquery === void 0 ? void 0 : osquery.fetchInstallationStatus();
  return !(osqueryStatus !== null && osqueryStatus !== void 0 && osqueryStatus.loading) && !(osqueryStatus !== null && osqueryStatus !== void 0 && osqueryStatus.disabled) && !(osqueryStatus !== null && osqueryStatus !== void 0 && osqueryStatus.permissionDenied);
};
exports.useOsqueryEnabled = useOsqueryEnabled;