"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INTEGRATIONS_UNINSTALLED_TOOLTIP = exports.INTEGRATIONS_UNINSTALLED = exports.INTEGRATIONS_POPOVER_TITLE = exports.INTEGRATIONS_POPOVER_DESCRIPTION = exports.INTEGRATIONS_INSTALLED_VERSION_TOOLTIP = exports.INTEGRATIONS_INSTALLED_TOOLTIP = exports.INTEGRATIONS_ENABLED_TOOLTIP = exports.INTEGRATIONS_ENABLED = exports.INTEGRATIONS_DISABLED = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INTEGRATIONS_DISABLED = exports.INTEGRATIONS_DISABLED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.relatedIntegrations.disabledTitle', {
  defaultMessage: 'Disabled'
});
const INTEGRATIONS_INSTALLED_TOOLTIP = exports.INTEGRATIONS_INSTALLED_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.relatedIntegrations.installedTooltip', {
  defaultMessage: 'Integration is installed. Configure an integration policy and ensure Elastic Agents are assigned this policy to ingest compatible events.'
});
const INTEGRATIONS_UNINSTALLED = exports.INTEGRATIONS_UNINSTALLED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.relatedIntegrations.uninstalledTitle', {
  defaultMessage: 'Not installed'
});
const INTEGRATIONS_UNINSTALLED_TOOLTIP = exports.INTEGRATIONS_UNINSTALLED_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.relatedIntegrations.uninstalledTooltip', {
  defaultMessage: 'Integration is not installed. Follow the integration link to install and configure the integration.'
});
const INTEGRATIONS_ENABLED = exports.INTEGRATIONS_ENABLED = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.relatedIntegrations.enabledTitle', {
  defaultMessage: 'Enabled'
});
const INTEGRATIONS_ENABLED_TOOLTIP = exports.INTEGRATIONS_ENABLED_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.relatedIntegrations.enabledTooltip', {
  defaultMessage: 'Integration is installed and an integration policy with the required configuration exists. Ensure Elastic Agents are assigned this policy to ingest compatible events.'
});
const INTEGRATIONS_POPOVER_TITLE = integrationsCount => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.relatedIntegrations.popoverTitle', {
  values: {
    integrationsCount
  },
  defaultMessage: '[{integrationsCount}] Related {integrationsCount, plural, =1 {integration} other {integrations}} available'
});
exports.INTEGRATIONS_POPOVER_TITLE = INTEGRATIONS_POPOVER_TITLE;
const INTEGRATIONS_POPOVER_DESCRIPTION = integrationsCount => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.relatedIntegrations.popoverDescription', {
  values: {
    integrationsCount
  },
  defaultMessage: 'Install and configure {integrationsCount, plural, =1 {the below integration} other {one or more of the below integrations}} to ingest the necessary data for this detection rule:'
});
exports.INTEGRATIONS_POPOVER_DESCRIPTION = INTEGRATIONS_POPOVER_DESCRIPTION;
const INTEGRATIONS_INSTALLED_VERSION_TOOLTIP = (installedVersion, requiredVersion) => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.relatedIntegrations.popoverDescriptionInstalledVersionTooltip', {
  values: {
    installedVersion,
    requiredVersion
  },
  defaultMessage: 'Version mismatch -- please resolve! Installed version `{installedVersion}` when required version `{requiredVersion}`'
});
exports.INTEGRATIONS_INSTALLED_VERSION_TOOLTIP = INTEGRATIONS_INSTALLED_VERSION_TOOLTIP;