"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NullGroup = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NullGroup = ({
  title,
  field,
  unit
}) => {
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react2.default.createElement("strong", null, title), /*#__PURE__*/_react2.default.createElement(_eui.EuiIconTip, {
    anchorProps: {
      css: (0, _react.css)`
            display: inline-flex;
          `
    },
    content: /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.grouping.nullGroupTooltip",
      defaultMessage: "The selected {groupingTitle} field, {field} is missing a value for this group of {unit}.",
      values: {
        groupingTitle: /*#__PURE__*/_react2.default.createElement("strong", null, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.assetInventory.grouping.nullGroupTooltip.groupingTitle",
          defaultMessage: "group by"
        })),
        field: /*#__PURE__*/_react2.default.createElement("code", null, field),
        unit
      }
    })),
    position: "right"
  }));
};
exports.NullGroup = NullGroup;