"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.roleGrantsSubFeaturePrivileges = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const roleGrantsSubFeaturePrivileges = (features, role) => {
  if (!role.kibana) {
    return false;
  }
  const subFeaturePrivileges = new Map(features.map(feature => [feature.id, feature.subFeatures.map(sf => sf.privilegeGroups.map(pg => pg.privileges)).flat(2)]));
  const hasAnySubFeaturePrivileges = role.kibana.some(kibanaPrivilege => {
    var _kibanaPrivilege$feat;
    return Object.entries((_kibanaPrivilege$feat = kibanaPrivilege.feature) !== null && _kibanaPrivilege$feat !== void 0 ? _kibanaPrivilege$feat : {}).some(([featureId, privileges]) => {
      var _subFeaturePrivileges;
      return !!((_subFeaturePrivileges = subFeaturePrivileges.get(featureId)) !== null && _subFeaturePrivileges !== void 0 && _subFeaturePrivileges.some(({
        id
      }) => privileges.includes(id)));
    });
  });
  return hasAnySubFeaturePrivileges;
};
exports.roleGrantsSubFeaturePrivileges = roleGrantsSubFeaturePrivileges;