"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setNotebookParameter = exports.removeNotebookParameter = exports.readNotebookParameter = void 0;
var _queryString = _interopRequireDefault(require("query-string"));
var _lzString = require("lz-string");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getBaseUrl() {
  return `${window.location.protocol}//${window.location.host}${window.location.pathname}`;
}
function parseQueryString() {
  const [hashRoute, queryString] = (window.location.hash || window.location.search || '').split('?');
  const parsedQueryString = _queryString.default.parse(queryString || '', {
    sort: false
  });
  return {
    hasHash: !!window.location.hash,
    hashRoute,
    queryString: parsedQueryString
  };
}
const setNotebookParameter = value => {
  const baseUrl = getBaseUrl();
  const {
    hasHash,
    hashRoute,
    queryString
  } = parseQueryString();
  const notebookId = (0, _lzString.compressToEncodedURIComponent)(value);
  queryString.notebookId = notebookId;
  const params = `?${_queryString.default.stringify(queryString)}`;
  const newUrl = hasHash ? `${baseUrl}${hashRoute}${params}` : `${baseUrl}${params}`;
  window.history.pushState({
    path: newUrl
  }, '', newUrl);
};
exports.setNotebookParameter = setNotebookParameter;
const removeNotebookParameter = () => {
  const baseUrl = getBaseUrl();
  const {
    hasHash,
    hashRoute,
    queryString
  } = parseQueryString();
  if (queryString.notebookId) {
    delete queryString.notebookId;
    const params = Object.keys(queryString).length ? `?${_queryString.default.stringify(queryString)}` : '';
    const newUrl = hasHash ? `${baseUrl}${hashRoute}${params}` : `${baseUrl}${params}`;
    window.history.pushState({
      path: newUrl
    }, '', newUrl);
  }
};
exports.removeNotebookParameter = removeNotebookParameter;
const readNotebookParameter = () => {
  const {
    queryString
  } = parseQueryString();
  if (queryString.notebookId && typeof queryString.notebookId === 'string') {
    try {
      const notebookId = (0, _lzString.decompressFromEncodedURIComponent)(queryString.notebookId);
      if (notebookId.length > 0) return notebookId;
    } catch {
      return undefined;
    }
  }
  return undefined;
};
exports.readNotebookParameter = readNotebookParameter;