"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.downloadToDisk = void 0;
var _fs = require("fs");
var _promises = require("fs/promises");
var _path = _interopRequireDefault(require("path"));
var _nodeFetch = _interopRequireDefault(require("node-fetch"));
var _local_artifacts = require("./local_artifacts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const downloadToDisk = async (fileUrl, filePath) => {
  const dirPath = _path.default.dirname(filePath);
  await (0, _promises.mkdir)(dirPath, {
    recursive: true
  });
  const writeStream = (0, _fs.createWriteStream)(filePath);
  let readStream;
  const parsedUrl = new URL(fileUrl);
  if (parsedUrl.protocol === 'file:') {
    const path = (0, _local_artifacts.resolveLocalArtifactsPath)(parsedUrl);
    readStream = (0, _fs.createReadStream)(path);
  } else {
    const res = await (0, _nodeFetch.default)(fileUrl);
    readStream = res.body;
  }
  await new Promise((resolve, reject) => {
    readStream.pipe(writeStream);
    readStream.on('error', reject);
    writeStream.on('finish', resolve);
  });
};
exports.downloadToDisk = downloadToDisk;