"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useErrorToast = void 0;
var _react = require("react");
var _kibana = require("../lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useErrorToast = () => {
  const [errorToast, setErrorToast] = (0, _react.useState)();
  const {
    notifications: {
      toasts
    }
  } = (0, _kibana.useKibana)().services;
  return (error, opts) => {
    if (errorToast) {
      toasts.remove(errorToast);
    }
    if (error) {
      var _error$body, _error$body2;
      setErrorToast(
      // @ts-expect-error update types
      toasts.addError(error, {
        title: (error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.error) || (error === null || error === void 0 ? void 0 : (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.message),
        ...opts
      }));
    }
  };
};
exports.useErrorToast = useErrorToast;