"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MONITOR_CLUSTER = exports.INDEX_LOGS_METRICS_AND_TRACES = exports.INDEX_LOGS_AND_METRICS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Grants all cluster read-only operations, like cluster health and state, hot threads, node info, node and cluster stats, and pending cluster tasks.
 */
const MONITOR_CLUSTER = exports.MONITOR_CLUSTER = 'monitor';

// https://www.elastic.co/guide/en/fleet/master/grant-access-to-elasticsearch.html#create-api-key-standalone-agent
const INDEX_LOGS_AND_METRICS = exports.INDEX_LOGS_AND_METRICS = {
  names: ['logs-*-*', 'logs', 'logs.*', 'metrics-*-*'],
  privileges: ['auto_configure', 'create_doc']
};

// https://www.elastic.co/guide/en/fleet/master/grant-access-to-elasticsearch.html#create-api-key-standalone-agent
const INDEX_LOGS_METRICS_AND_TRACES = exports.INDEX_LOGS_METRICS_AND_TRACES = {
  names: ['logs-*-*', 'logs', 'logs.*', 'metrics-*-*', 'traces-*-*'],
  privileges: ['auto_configure', 'create_doc']
};