"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFunctionRequestMessage = createFunctionRequestMessage;
var _uuid = require("uuid");
var _ = require("..");
var _conversation_complete = require("../conversation_complete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createFunctionRequestMessage({
  name,
  args
}) {
  return {
    id: (0, _uuid.v4)(),
    type: _conversation_complete.StreamingChatResponseEventType.MessageAdd,
    message: {
      '@timestamp': new Date().toISOString(),
      message: {
        function_call: {
          name,
          arguments: JSON.stringify(args),
          trigger: _.MessageRole.Assistant
        },
        role: _.MessageRole.Assistant,
        content: ''
      }
    }
  };
}