"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNavMenu = TopNavMenu;
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _top_nav_menu_items = require("./top_nav_menu_items");
var _top_nav_menu_badges = require("./top_nav_menu_badges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/*
 * Top Nav Menu is a convenience wrapper component for:
 * - Top navigation menu - configured by an array of `TopNavMenuData` objects
 * - Search Bar - which includes Filter Bar \ Query Input \ Timepicker.
 *
 * See SearchBar documentation to learn more about its properties.
 *
 **/

function TopNavMenu(props) {
  const {
    config,
    badges,
    showSearchBar,
    gutterSize,
    ...searchBarProps
  } = props;
  if ((!config || config.length === 0) && (!showSearchBar || !props.unifiedSearch)) {
    return null;
  }
  function renderBadges() {
    return /*#__PURE__*/_react2.default.createElement(_top_nav_menu_badges.TopNavMenuBadges, {
      badges: badges
    });
  }
  function renderMenu() {
    return /*#__PURE__*/_react2.default.createElement(_top_nav_menu_items.TopNavMenuItems, {
      config: config,
      className: props.className,
      "data-test-subj": "kbn-top-nav-menu-wrapper",
      css: (0, _react.css)`
          button:last-child {
            margin-right: 0;
          }
        `,
      popoverBreakpoints: props.popoverBreakpoints,
      gutterSize: gutterSize
    });
  }
  function renderSearchBar() {
    // Validate presence of all required fields
    if (!showSearchBar || !props.unifiedSearch) return null;
    const {
      AggregateQuerySearchBar
    } = props.unifiedSearch.ui;
    return /*#__PURE__*/_react2.default.createElement(AggregateQuerySearchBar, searchBarProps);
  }
  function renderLayout() {
    const {
      setMenuMountPoint,
      visible
    } = props;
    const styles = {
      badgeWrapper: (0, _react.css)`
        display: flex;
        align-items: center;
      `,
      hidden: (0, _react.css)`
        display: none;
      `
    };
    if (setMenuMountPoint) {
      const badgesEl = renderBadges();
      const menuEl = renderMenu();
      return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, (badgesEl || menuEl) && /*#__PURE__*/_react2.default.createElement(_reactKibanaMount.MountPointPortal, {
        setMountPoint: setMenuMountPoint
      }, /*#__PURE__*/_react2.default.createElement("span", {
        className: "kbnTopNavMenu__wrapper",
        css: [styles.badgeWrapper, visible === false && styles.hidden]
      }, badgesEl, menuEl)), renderSearchBar());
    } else {
      return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("span", {
        css: [visible === false && styles.hidden]
      }, renderMenu()), renderSearchBar());
    }
  }
  return renderLayout();
}
TopNavMenu.defaultProps = {
  showSearchBar: false,
  showQueryInput: true,
  showDatePicker: true,
  showFilterBar: true,
  screenTitle: ''
};