"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Anomalies = void 0;
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAnomalyStyle(threshold, euiTheme) {
  return {
    line: {
      stroke: (0, _mlAnomalyUtils.getThemeResolvedSeverityColor)(threshold, euiTheme),
      strokeWidth: 3,
      opacity: 1
    }
  };
}
function splitAnomalySeverities(anomalies) {
  const severities = {
    critical: [],
    major: [],
    minor: [],
    warning: [],
    unknown: [],
    low: []
  };
  anomalies.forEach(a => {
    if (a.value !== 0) {
      severities[a.severity].push({
        dataValue: a.time
      });
    }
  });
  return severities;
}
const Anomalies = ({
  anomalyData
}) => {
  const anomalies = anomalyData === undefined ? [] : anomalyData;
  const severities = splitAnomalySeverities(anomalies);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "low",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: severities.low,
    style: getAnomalyStyle(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.LOW, euiTheme),
    hideTooltips: true
  }), /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "warning",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: severities.warning,
    style: getAnomalyStyle(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.WARNING, euiTheme),
    hideTooltips: true
  }), /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "minor",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: severities.minor,
    style: getAnomalyStyle(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MINOR, euiTheme),
    hideTooltips: true
  }), /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "major",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: severities.major,
    style: getAnomalyStyle(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.MAJOR, euiTheme),
    hideTooltips: true
  }), /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "critical",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: severities.critical,
    style: getAnomalyStyle(_mlAnomalyUtils.ML_ANOMALY_THRESHOLD.CRITICAL, euiTheme),
    hideTooltips: true
  }));
};
exports.Anomalies = Anomalies;