"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineDetailsTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../contexts/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelineDetailsTitle = ({
  modelId
}) => {
  const {
    services: {
      docLinks: {
        links
      }
    }
  } = (0, _kibana.useMlKibana)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.title', {
    defaultMessage: 'Create a pipeline'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.description",
    defaultMessage: "Build a {pipeline} to use the trained model - {modelId} - for inference.",
    values: {
      modelId: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, modelId),
      pipeline: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        target: "_blank",
        href: links.ingest.pipelines
      }, "pipeline")
    }
  })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.configure.descriptionUsePipelines",
    defaultMessage: "Use {pipelineSimulateLink} or {reindexLink} to pass data into this pipeline. Predictions are stored in the Target field.",
    values: {
      reindexLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        target: "_blank",
        href: links.upgradeAssistant.reindexWithPipeline
      }, "_reindex API"),
      pipelineSimulateLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        target: "_blank",
        href: links.apis.simulatePipeline
      }, "pipeline/_simulate")
    }
  }))));
};
exports.PipelineDetailsTitle = PipelineDetailsTitle;