"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DynamicOrientationProperty = void 0;
var _dynamic_style_property = require("./dynamic_style_property");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DynamicOrientationProperty extends _dynamic_style_property.DynamicStyleProperty {
  syncIconRotationWithMb(symbolLayerId, mbMap) {
    if (this._field && this._field.isValid()) {
      const targetName = this.getMbPropertyName();
      mbMap.setLayoutProperty(symbolLayerId, 'icon-rotate', ['coalesce', [this.getMbLookupFunction(), targetName], 0]);
    } else {
      mbMap.setLayoutProperty(symbolLayerId, 'icon-rotate', 0);
    }
  }
  supportsFieldMeta() {
    return false;
  }
  supportsFeatureState() {
    return false;
  }
}
exports.DynamicOrientationProperty = DynamicOrientationProperty;