"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Category = Category;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _constants = require("../../../../../../common/constants");
var _vector_icon = require("./vector_icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function Category({
  styleName,
  label,
  color,
  isLinesOnly,
  isPointsOnly,
  symbolId,
  svg
}) {
  const styles = (0, _use_memo_css.useMemoCss)(categoryStyles);
  function renderIcon() {
    if (styleName === _constants.VECTOR_STYLES.LABEL_COLOR) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        style: {
          color
        }
      }, "Tx");
    }
    return /*#__PURE__*/_react.default.createElement(_vector_icon.VectorIcon, {
      fillColor: styleName === _constants.VECTOR_STYLES.FILL_COLOR ? color : 'none',
      isPointsOnly: isPointsOnly,
      isLinesOnly: isLinesOnly,
      strokeColor: color,
      symbolId: symbolId,
      svg: svg
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.itemMargin,
    grow: false
  }, renderIcon()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, label)));
}
const categoryStyles = {
  itemMargin: ({
    euiTheme
  }) => (0, _react2.css)({
    width: euiTheme.size.l
  })
};