"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToRawColorMappingsFn = void 0;
var _raw_color_mappings = require("../../../../runtime_state/converters/raw_color_mappings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/** @deprecated */

/**
 * Old color mapping state meant for type safety during runtime migrations of old configurations
 *
 * @deprecated
 */

const convertToRawColorMappingsFn = datasourceStates => {
  const getColumnMeta = (0, _raw_color_mappings.getColumnMetaFn)(datasourceStates);
  return state => {
    const hasDeprecatedColorMappings = state.layers.some(layer => {
      return layer.layerType === 'data' && (0, _raw_color_mappings.isDeprecatedColorMapping)(layer.colorMapping);
    });
    if (!hasDeprecatedColorMappings) return state;
    const convertedLayers = state.layers.map(layer => {
      var _layer$colorMapping, _layer$colorMapping2;
      if (layer.layerType === 'data' && ((_layer$colorMapping = layer.colorMapping) !== null && _layer$colorMapping !== void 0 && _layer$colorMapping.assignments || (_layer$colorMapping2 = layer.colorMapping) !== null && _layer$colorMapping2 !== void 0 && _layer$colorMapping2.specialAssignments)) {
        const accessor = layer.splitAccessor;
        const columnMeta = accessor ? getColumnMeta === null || getColumnMeta === void 0 ? void 0 : getColumnMeta(layer.layerId, accessor) : null;
        return {
          ...layer,
          colorMapping: (0, _raw_color_mappings.convertToRawColorMappings)(layer.colorMapping, columnMeta)
        };
      }
      return layer;
    });
    return {
      ...state,
      layers: convertedLayers
    };
  };
};
exports.convertToRawColorMappingsFn = convertToRawColorMappingsFn;