"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeDetailsPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _no_data_config = require("../../../../components/shared/templates/no_data_config");
var _infra_page_template = require("../../../../components/shared/templates/infra_page_template");
var _node_details_api = require("../../../../../common/http_api/node_details_api");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_page_header = require("../../../../components/asset_details/hooks/use_page_header");
var _side_nav = require("./side_nav");
var _time_controls = require("./time_controls");
var _side_nav_context = require("../lib/side_nav_context");
var _page_body = require("./page_body");
var _page_error = require("./page_error");
var _metadata_context = require("../containers/metadata_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseRange = range => {
  const parsedFrom = _datemath.default.parse(range.from.toString());
  const parsedTo = _datemath.default.parse(range.to.toString(), {
    roundUp: true
  });
  return {
    ...range,
    from: parsedFrom && parsedFrom.valueOf() || (0, _moment.default)().subtract(1, 'hour').valueOf(),
    to: parsedTo && parsedTo.valueOf() || (0, _moment.default)().valueOf()
  };
};
const NodeDetailsPage = props => {
  const {
    breadcrumbs
  } = (0, _use_page_header.useTemplateHeaderBreadcrumbs)();
  const {
    data,
    status,
    error,
    refetch
  } = (0, _use_fetcher.useFetcher)(async callApi => {
    const response = await callApi('/api/metrics/node_details', {
      method: 'POST',
      body: JSON.stringify({
        metrics: props.requiredMetrics,
        nodeId: props.nodeId,
        nodeType: props.nodeType,
        timerange: parseRange(props.timeRange),
        cloudId: props.cloudId,
        sourceId: props.sourceId
      })
    });
    return (0, _ioTsUtils.decodeOrThrow)(_node_details_api.NodeDetailsMetricDataResponseRT)(response);
  }, [props.cloudId, props.nodeId, props.nodeType, props.requiredMetrics, props.sourceId, props.timeRange]);
  const {
    metrics = []
  } = data !== null && data !== void 0 ? data : {};
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_page_error.PageError, {
      error: error,
      name: props.name
    });
  }
  return /*#__PURE__*/_react.default.createElement(_infra_page_template.InfraPageTemplate, {
    onboardingFlow: _no_data_config.OnboardingFlow.Infra,
    pageHeader: {
      pageTitle: props.name,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_time_controls.MetricsTimeControls, {
        currentTimeRange: props.timeRange,
        isLiveStreaming: props.isAutoReloading,
        refreshInterval: props.refreshInterval,
        setRefreshInterval: props.setRefreshInterval,
        onChangeTimeRange: props.setTimeRange,
        setAutoReload: props.setAutoReload,
        onRefresh: refetch
      })],
      breadcrumbs
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_side_nav.MetricsSideNav, {
    loading: props.metadataLoading,
    name: props.name,
    items: props.sideNav
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_side_nav_context.SideNavContext.Provider, {
    value: {
      items: props.sideNav,
      addNavItem: props.addNavItem
    }
  }, /*#__PURE__*/_react.default.createElement(_metadata_context.MetadataContext.Provider, {
    value: props.metadata
  }, /*#__PURE__*/_react.default.createElement(_page_body.PageBody, {
    loading: metrics.length > 0 && props.isAutoReloading ? false : (0, _use_fetcher.isPending)(status),
    refetch: refetch,
    type: props.nodeType,
    metrics: metrics,
    onChangeRangeTime: props.setTimeRange,
    isLiveStreaming: props.isAutoReloading,
    stopLiveStreaming: () => props.setAutoReload(false)
  }))))));
};
exports.NodeDetailsPage = NodeDetailsPage;