"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toGroupByOpt = exports.ToolbarWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _field_to_display_name = require("../../lib/field_to_display_name");
var _use_waffle_options = require("../../hooks/use_waffle_options");
var _waffle_inventory_switcher = require("../waffle/waffle_inventory_switcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ToolbarWrapper = props => {
  const {
    changeMetric,
    changeGroupBy,
    changeCustomOptions,
    changeAccount,
    changeRegion,
    changeSort,
    customOptions,
    groupBy,
    metric,
    nodeType,
    accountId,
    view,
    region,
    legend,
    sort,
    customMetrics,
    changeCustomMetrics
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: true,
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_waffle_inventory_switcher.WaffleInventorySwitcher, null)), props.children({
    changeMetric,
    changeGroupBy,
    changeAccount,
    changeRegion,
    changeCustomOptions,
    changeSort,
    customOptions,
    groupBy,
    sort,
    view,
    metric,
    nodeType,
    region,
    accountId,
    legend,
    customMetrics,
    changeCustomMetrics
  }));
};
exports.ToolbarWrapper = ToolbarWrapper;
const toGroupByOpt = field => ({
  text: (0, _field_to_display_name.fieldToName)(field),
  field
});
exports.toGroupByOpt = toGroupByOpt;