"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestionItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _public = require("@kbn/unified-search-plugin/public");
var _polished = require("polished");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SuggestionItem = props => {
  const {
    isSelected,
    onClick,
    onMouseEnter,
    suggestion
  } = props;
  return /*#__PURE__*/_react.default.createElement(SuggestionItemContainer, {
    isSelected: isSelected,
    onClick: onClick,
    onMouseEnter: onMouseEnter
  }, /*#__PURE__*/_react.default.createElement(SuggestionItemIconField, {
    suggestionType: suggestion.type
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: getEuiIconType(suggestion.type)
  })), /*#__PURE__*/_react.default.createElement(SuggestionItemTextField, null, suggestion.text), /*#__PURE__*/_react.default.createElement(SuggestionItemDescriptionField, null, suggestion.description));
};
exports.SuggestionItem = SuggestionItem;
SuggestionItem.defaultProps = {
  isSelected: false
};
const SuggestionItemContainer = _styled.default.div`
  display: flex;
  flex-direction: row;
  font-size: ${() => (0, _eui.useEuiFontSize)('m').fontSize};
  height: ${({
  theme
}) => theme.euiTheme.size.xl};
  white-space: nowrap;
  background-color: ${props => props.isSelected ? props.theme.euiTheme.colors.lightestShade : 'transparent'};
`;
const SuggestionItemField = _styled.default.div`
  align-items: center;
  cursor: pointer;
  display: flex;
  flex-direction: row;
  height: ${({
  theme
}) => theme.euiTheme.size.xl};
  padding: ${({
  theme
}) => theme.euiTheme.size.xs};
`;
const SuggestionItemIconField = (0, _styled.default)(SuggestionItemField)`
  background-color: ${({
  theme,
  suggestionType
}) => (0, _polished.transparentize)(0.9, getEuiIconColor(theme, suggestionType))};
  color: ${({
  theme,
  suggestionType
}) => getEuiIconColor(theme, suggestionType)};
  flex: 0 0 auto;
  justify-content: center;
  width: ${({
  theme
}) => theme.euiTheme.size.xl};
`;
const SuggestionItemTextField = (0, _styled.default)(SuggestionItemField)`
  flex: 2 0 0;
  font-family: ${({
  theme
}) => theme.euiTheme.font.familyCode};
`;
const SuggestionItemDescriptionField = (0, _styled.default)(SuggestionItemField)`
  flex: 3 0 0;

  p {
    display: inline;

    span {
      font-family: ${({
  theme
}) => theme.euiTheme.font.familyCode};
    }
  }
`;
const getEuiIconType = suggestionType => {
  switch (suggestionType) {
    case _public.QuerySuggestionTypes.Field:
      return 'kqlField';
    case _public.QuerySuggestionTypes.Value:
      return 'kqlValue';
    case _public.QuerySuggestionTypes.RecentSearch:
      return 'search';
    case _public.QuerySuggestionTypes.Conjunction:
      return 'kqlSelector';
    case _public.QuerySuggestionTypes.Operator:
      return 'kqlOperand';
    default:
      return 'empty';
  }
};
const getEuiIconColor = (theme, suggestionType) => {
  switch (suggestionType) {
    case _public.QuerySuggestionTypes.Field:
      return theme === null || theme === void 0 ? void 0 : theme.euiTheme.colors.vis.euiColorVis7;
    case _public.QuerySuggestionTypes.Value:
      return theme === null || theme === void 0 ? void 0 : theme.euiTheme.colors.vis.euiColorVis0;
    case _public.QuerySuggestionTypes.Operator:
      return theme === null || theme === void 0 ? void 0 : theme.euiTheme.colors.vis.euiColorVis1;
    case _public.QuerySuggestionTypes.Conjunction:
      return theme === null || theme === void 0 ? void 0 : theme.euiTheme.colors.vis.euiColorVis2;
    case _public.QuerySuggestionTypes.RecentSearch:
    default:
      return theme === null || theme === void 0 ? void 0 : theme.euiTheme.colors.mediumShade;
  }
};