"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getESQueryForLogRateAnalysis = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _lodash = require("lodash");
var _query_helpers = require("../../../../../common/alerting/logs/log_threshold/query_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getESQueryForLogRateAnalysis = (params, timestampField, alert, groupBy) => {
  const {
    mustFilters,
    mustNotFilters,
    mustFiltersFields
  } = (0, _query_helpers.buildFiltersFromCriteria)(params, timestampField);
  const groupByFilters = groupBy ? groupBy.filter(groupByField => !mustFiltersFields.includes(groupByField)).map(groupByField => {
    const groupByValue = (0, _lodash.get)(alert.fields[_ruleDataUtils.ALERT_CONTEXT], ['groupByKeys', ...groupByField.split('.')], null);
    return groupByValue ? {
      term: {
        [groupByField]: {
          value: groupByValue
        }
      }
    } : null;
  }).filter(groupByFilter => groupByFilter) : [];
  const query = {
    bool: {
      filter: [...mustFilters, ...groupByFilters],
      ...(mustNotFilters.length > 0 && {
        must_not: mustNotFilters
      })
    }
  };
  return query;
};
exports.getESQueryForLogRateAnalysis = getESQueryForLogRateAnalysis;