"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricValueFormatter = void 0;
var _i18n = require("@kbn/i18n");
var _formatters = require("../../formatters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const metricValueFormatter = (value, metric = '') => {
  const noDataValue = _i18n.i18n.translate('xpack.infra.metrics.alerting.noDataFormattedValue', {
    defaultMessage: '[NO DATA]'
  });
  const formatter = metric.endsWith('.pct') ? (0, _formatters.createFormatter)('percent') : (0, _formatters.createFormatter)('highPrecision');
  return value == null ? noDataValue : formatter(value);
};
exports.metricValueFormatter = metricValueFormatter;