"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inferenceTracingExportConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scheduledDelay = _configSchema.schema.conditional(_configSchema.schema.contextRef('dev'), true, _configSchema.schema.number({
  defaultValue: 1000
}), _configSchema.schema.number({
  defaultValue: 5000
}));
const langfuseExportConfigSchema = _configSchema.schema.object({
  base_url: _configSchema.schema.uri(),
  public_key: _configSchema.schema.string(),
  secret_key: _configSchema.schema.string(),
  scheduled_delay: scheduledDelay
});
const phoenixExportConfigSchema = _configSchema.schema.object({
  base_url: _configSchema.schema.string(),
  public_url: _configSchema.schema.maybe(_configSchema.schema.uri()),
  project_name: _configSchema.schema.maybe(_configSchema.schema.string()),
  api_key: _configSchema.schema.maybe(_configSchema.schema.string()),
  scheduled_delay: scheduledDelay
});
const inferenceTracingExportConfigSchema = exports.inferenceTracingExportConfigSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  langfuse: langfuseExportConfigSchema
}), _configSchema.schema.object({
  phoenix: phoenixExportConfigSchema
})]);