"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bindClient = void 0;
var _chat_complete = require("../chat_complete");
var _prompt = require("../prompt");
var _output = require("../output");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bindClient = (unboundClient, boundParams) => {
  return {
    ...unboundClient,
    chatComplete: (0, _chat_complete.bindChatComplete)(unboundClient.chatComplete, boundParams),
    prompt: (0, _prompt.bindPrompt)(unboundClient.prompt, boundParams),
    output: (0, _output.bindOutput)(unboundClient.output, boundParams)
  };
};
exports.bindClient = bindClient;