"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BreakingChangesFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _css = require("@emotion/css");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BreakingChangeListItems = ({
  changes
}) => {
  return changes.map(({
    link,
    description
  }) => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: link
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued"
    }, description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: link,
      target: "_blank",
      color: "primary",
      "data-test-subj": "breakingChangeLink"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      component: "span"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrations.settings.breakingChangesFlyout.prLinkText",
      defaultMessage: "Review changes"
    }))));
  });
};
const BreakingChangesList = ({
  changelog
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("ul", {
    className: (0, _css.css)`
        li:nth-child(even) {
          background-color: ${euiTheme.colors.backgroundBaseSubdued};
        }
      `
  }, changelog.map(({
    version,
    changes
  }) => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: version,
      className: (0, _css.css)`
              padding: ${euiTheme.size.l};
            `
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.integrations.settings.breakingChangesFlyout.changeVersionHeader",
      defaultMessage: "Version {version}",
      values: {
        version
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs"
    }), /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement(BreakingChangeListItems, {
      changes: changes
    })));
  }));
};
const BreakingChangesFlyout = ({
  onClose,
  breakingChanges
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: "m",
    paddingSize: "none",
    "aria-labelledby": flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _css.css)`
            padding: ${euiTheme.size.l};
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.breakingChangesFlyout.headerTitle",
    defaultMessage: "Review breaking changes"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.integrations.settings.breakingChangesFlyout.headerDescription",
    defaultMessage: "Please review the changes carefully before upgrading."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(BreakingChangesList, {
    changelog: breakingChanges
  })));
};
exports.BreakingChangesFlyout = BreakingChangesFlyout;