"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoUpgradeAgentsTour = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AutoUpgradeAgentsTour = ({
  anchor
}) => {
  const {
    isOpen,
    dismiss
  } = (0, _hooks.useDismissableTour)('AUTO_UPGRADE_AGENTS');
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep, {
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.autoUpgradeAgentsTour.tourContent",
      defaultMessage: "Select your policy and configure target agent versions for automatic upgrades."
    })),
    isStepOpen: isOpen,
    onFinish: dismiss,
    minWidth: 360,
    maxWidth: 360,
    step: 1,
    stepsTotal: 1,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.autoUpgradeAgentsTour.tourTitle",
      defaultMessage: "Auto-upgrade agents"
    }),
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: dismiss
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.genericTourPopover.dismissButton",
      defaultMessage: "Got it"
    })),
    anchorPosition: "downLeft",
    anchor: anchor
  }));
};
exports.AutoUpgradeAgentsTour = AutoUpgradeAgentsTour;