"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WithMultiContent = WithMultiContent;
var _react = _interopRequireDefault(require("react"));
var _multi_content_context = require("./multi_content_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * HOC to wrap a component with the MultiContentProvider
 *
 * @param Component The component to wrap with the MultiContentProvider
 */
function WithMultiContent(Component) {
  return function (props) {
    const {
      defaultValue,
      onChange,
      ...rest
    } = props;
    return /*#__PURE__*/_react.default.createElement(_multi_content_context.MultiContentProvider, {
      defaultValue: defaultValue,
      onChange: onChange
    }, /*#__PURE__*/_react.default.createElement(Component, rest));
  };
}