"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entityDefinitionExists = entityDefinitionExists;
exports.saveEntityDefinition = saveEntityDefinition;
exports.updateEntityDefinition = updateEntityDefinition;
var _saved_objects = require("../../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function saveEntityDefinition(soClient, definition) {
  await soClient.create(_saved_objects.SO_ENTITY_DEFINITION_TYPE, definition, {
    id: definition.id,
    managed: definition.managed,
    overwrite: true
  });
  return definition;
}
async function entityDefinitionExists(soClient, id) {
  const response = await soClient.find({
    type: _saved_objects.SO_ENTITY_DEFINITION_TYPE,
    page: 1,
    perPage: 1,
    filter: `${_saved_objects.SO_ENTITY_DEFINITION_TYPE}.attributes.id:(${id})`
  });
  return response.total === 1;
}
async function updateEntityDefinition(soClient, id, definition) {
  return await soClient.update(_saved_objects.SO_ENTITY_DEFINITION_TYPE, id, definition);
}