"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnterpriseSearchContentConfigured = exports.EnterpriseSearchContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _connectors_router = require("./components/connectors/connectors_router");
var _crawlers_router = require("./components/connectors/crawlers_router");
var _not_found = require("./components/not_found");
var _search_indices = require("./components/search_indices");
var _routes = require("./routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EnterpriseSearchContent = props => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(EnterpriseSearchContentConfigured, props)));
};
exports.EnterpriseSearchContent = EnterpriseSearchContent;
const EnterpriseSearchContentConfigured = () => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    exact: true,
    from: _routes.ROOT_PATH,
    to: _routes.SEARCH_INDICES_PATH
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SEARCH_INDICES_PATH
  }, /*#__PURE__*/_react.default.createElement(_search_indices.SearchIndicesRouter, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.CONNECTORS_PATH
  }, /*#__PURE__*/_react.default.createElement(_connectors_router.ConnectorsRouter, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.CRAWLERS_PATH
  }, /*#__PURE__*/_react.default.createElement(_crawlers_router.CrawlersRouter, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_not_found.NotFound, null)));
};
exports.EnterpriseSearchContentConfigured = EnterpriseSearchContentConfigured;