"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddConnectorLogic = void 0;
var _kea = require("kea");
var _error_codes = require("../../../../../../common/types/error_codes");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _kibana = require("../../../../shared/kibana");
var _add_connector_api_logic = require("../../../api/connector/add_connector_api_logic");
var _routes = require("../../../routes");
var _search_index = require("../../search_index/search_index");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddConnectorLogic = exports.AddConnectorLogic = (0, _kea.kea)({
  actions: {
    setIsModalVisible: isModalVisible => ({
      isModalVisible
    })
  },
  connect: {
    actions: [_add_connector_api_logic.AddConnectorApiLogic, ['apiError', 'apiSuccess', 'makeRequest', 'apiReset']]
  },
  listeners: {
    apiSuccess: async ({
      id
    }) => {
      _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_TAB_PATH, {
        connectorId: id,
        tabId: _search_index.SearchIndexTabId.CONFIGURATION
      }));
    }
  },
  path: ['enterprise_search', 'content', 'add_connector'],
  reducers: {
    isModalVisible: [false, {
      apiError: (_, error) => {
        var _error$body, _error$body$attribute;
        return ((_error$body = error.body) === null || _error$body === void 0 ? void 0 : (_error$body$attribute = _error$body.attributes) === null || _error$body$attribute === void 0 ? void 0 : _error$body$attribute.error_code) === _error_codes.ErrorCode.CONNECTOR_DOCUMENT_ALREADY_EXISTS;
      },
      apiSuccess: () => false,
      setIsModalVisible: (_, {
        isModalVisible
      }) => isModalVisible
    }]
  }
});