"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findKnowledgeBaseEntriesRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _lodash = _interopRequireDefault(require("lodash"));
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _utils = require("../../utils");
var _helpers = require("../../helpers");
var _transforms = require("../../../ai_assistant_data_clients/knowledge_base/transforms");
var _utils2 = require("./utils");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findKnowledgeBaseEntriesRoute = router => {
  router.versioned.get({
    access: 'public',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_ENTRIES_URL_FIND,
    security: {
      authz: {
        requiredPrivileges: ['elasticAssistant']
      }
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    validate: {
      request: {
        query: (0, _common.buildRouteValidationWithZod)(_elasticAssistantCommon.FindKnowledgeBaseEntriesRequestQuery)
      }
    }
  }, async (context, request, response) => {
    const assistantResponse = (0, _utils.buildResponse)(response);
    try {
      var _query$fields;
      const {
        query
      } = request;
      const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);

      // Perform license, authenticated user and FF checks
      const checkResponse = await (0, _helpers.performChecks)({
        context: ctx,
        request,
        response
      });
      if (!checkResponse.isSuccess) {
        return checkResponse.response;
      }
      const kbDataClient = await ctx.elasticAssistant.getAIAssistantKnowledgeBaseDataClient();
      const currentUser = checkResponse.currentUser;
      const userFilter = (0, _utils2.getKBUserFilter)(currentUser);
      const systemFilter = ` AND (kb_resource:"user" OR type:"index")`;
      const additionalFilter = query.filter ? ` AND ${query.filter}` : '';
      const result = await (kbDataClient === null || kbDataClient === void 0 ? void 0 : kbDataClient.findDocuments({
        perPage: query.per_page,
        page: query.page,
        sortField: query.sort_field,
        sortOrder: query.sort_order,
        filter: `${userFilter}${systemFilter}${additionalFilter}`,
        fields: (_query$fields = query.fields) === null || _query$fields === void 0 ? void 0 : _query$fields.map(f => _lodash.default.snakeCase(f)),
        aggs: {
          global_aggs: {
            global: {},
            aggs: {
              kb_resource_aggregation: {
                terms: {
                  field: 'kb_resource',
                  size: 10,
                  exclude: ['user']
                },
                aggs: {
                  top_documents: {
                    top_hits: {
                      size: 1
                    }
                  }
                }
              }
            }
          }
        }
      }));
      const systemEntries = [{
        bucketId: 'securityLabsId',
        kbResource: _constants.SECURITY_LABS_RESOURCE,
        name: 'Security Labs',
        required: true
      }].map(({
        bucketId,
        kbResource,
        name,
        required
      }) => {
        var _result$data$aggregat, _result$data$aggregat2, _result$data$aggregat3, _bucket$top_documents, _bucket$top_documents2, _bucket$top_documents3, _bucket$top_documents4;
        const bucket = _lodash.default.find(result === null || result === void 0 ? void 0 : (_result$data$aggregat = result.data.aggregations) === null || _result$data$aggregat === void 0 ? void 0 : (_result$data$aggregat2 = _result$data$aggregat.global_aggs) === null || _result$data$aggregat2 === void 0 ? void 0 : (_result$data$aggregat3 = _result$data$aggregat2.kb_resource_aggregation) === null || _result$data$aggregat3 === void 0 ? void 0 : _result$data$aggregat3.buckets, ['key', kbResource]);
        const entry = bucket === null || bucket === void 0 ? void 0 : (_bucket$top_documents = bucket.top_documents) === null || _bucket$top_documents === void 0 ? void 0 : (_bucket$top_documents2 = _bucket$top_documents.hits) === null || _bucket$top_documents2 === void 0 ? void 0 : (_bucket$top_documents3 = _bucket$top_documents2.hits) === null || _bucket$top_documents3 === void 0 ? void 0 : (_bucket$top_documents4 = _bucket$top_documents3[0]) === null || _bucket$top_documents4 === void 0 ? void 0 : _bucket$top_documents4._source;
        const entryCount = bucket === null || bucket === void 0 ? void 0 : bucket.doc_count;
        const entries = entry == null ? [] : [{
          id: bucketId,
          createdAt: entry.created_at,
          createdBy: entry.created_by,
          updatedAt: entry.updated_at,
          updatedBy: entry.updated_by,
          global: true,
          users: [],
          name,
          namespace: entry.namespace,
          type: _elasticAssistantCommon.DocumentEntryType.value,
          kbResource,
          source: '',
          required,
          text: `${entryCount}`
        }];
        return entries;
      }).flat();
      if (result) {
        return response.ok({
          body: {
            perPage: result.perPage,
            page: result.page,
            total: result.total + systemEntries.length,
            data: [...(0, _transforms.transformESSearchToKnowledgeBaseEntry)(result.data), ...systemEntries]
          }
        });
      }
      return response.ok({
        body: {
          perPage: query.per_page,
          page: query.page,
          data: [],
          total: 0
        }
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return assistantResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.findKnowledgeBaseEntriesRoute = findKnowledgeBaseEntriesRoute;