"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandableTruncatedText = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactHooks = require("@kbn/react-hooks");
var _translations = require("../../../../common/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExpandableTruncatedText = ({
  text,
  maxCharLength = 150,
  truncatedTextLength = 35,
  codeLanguage
}) => {
  const {
    displayText,
    isExpanded,
    toggleExpanded,
    shouldTruncate
  } = (0, _reactHooks.useTruncateText)(text, maxCharLength, truncatedTextLength);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    style: {
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    language: codeLanguage,
    style: {
      fontWeight: 'normal'
    }
  }, displayText), shouldTruncate && /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, /*#__PURE__*/_react.default.createElement("button", {
    "data-test-subj": "truncatedTextToggle",
    onClick: toggleExpanded,
    color: "primary",
    css: {
      fontWeight: 'bold',
      textDecoration: 'underline'
    }
  }, isExpanded ? _translations.readLess : _translations.readMore)));
};
exports.ExpandableTruncatedText = ExpandableTruncatedText;