"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScriptingHelpFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _scripting_syntax = require("./scripting_syntax");
var _test_script = require("./test_script");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ScriptingHelpFlyout = ({
  isVisible = false,
  onClose = () => {},
  indexPattern,
  lang,
  name,
  script,
  executeScript
}) => {
  const tabs = [{
    id: 'syntax',
    name: 'Syntax',
    ['data-test-subj']: 'syntaxTab',
    content: /*#__PURE__*/_react.default.createElement(_scripting_syntax.ScriptingSyntax, null)
  }, {
    id: 'test',
    name: 'Preview results',
    ['data-test-subj']: 'testTab',
    content: /*#__PURE__*/_react.default.createElement(_test_script.TestScript, {
      indexPattern: indexPattern,
      lang: lang,
      name: name,
      script: script,
      executeScript: executeScript
    })
  }];
  return isVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "scriptedFieldsHelpFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: tabs,
    initialSelectedTab: tabs[0]
  }))) : null;
};
exports.ScriptingHelpFlyout = ScriptingHelpFlyout;
ScriptingHelpFlyout.displayName = 'ScriptingHelpFlyout';