"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerApiDeprecationsInfo = exports.createGetApiDeprecations = void 0;
var _route_deprecations = require("./route/route_deprecations");
var _access_deprecations = require("./access/access_deprecations");
var _api_deprecation_id = require("./api_deprecation_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createGetApiDeprecations = ({
  http,
  coreUsageData,
  docLinks
}) => async () => {
  const usageClient = coreUsageData.getClient();
  const deprecatedApis = http.getRegisteredDeprecatedApis();
  const deprecatedApiUsageStats = await usageClient.getDeprecatedApiUsageStats();
  return deprecatedApiUsageStats.filter(({
    apiTotalCalls,
    totalMarkedAsResolved
  }) => {
    return apiTotalCalls > totalMarkedAsResolved;
  }).filter(({
    apiId
  }) => deprecatedApis.some(routeDetails => (0, _api_deprecation_id.buildApiDeprecationId)(routeDetails) === apiId)).map(apiUsageStats => {
    const {
      apiId
    } = apiUsageStats;
    const deprecatedApiDetails = deprecatedApis.find(routeDetails => (0, _api_deprecation_id.buildApiDeprecationId)(routeDetails) === apiId);
    if (!deprecatedApiDetails) {
      throw new Error(`Unable to find deprecation details for "${apiId}"`);
    }
    const {
      routeAccess
    } = deprecatedApiDetails;
    switch (routeAccess) {
      case 'public':
        {
          return (0, _route_deprecations.buildApiRouteDeprecationDetails)({
            apiUsageStats,
            deprecatedApiDetails,
            docLinks
          });
        }
      // if no access is specified then internal is the default
      case 'internal':
      default:
        {
          return (0, _access_deprecations.buildApiAccessDeprecationDetails)({
            apiUsageStats,
            deprecatedApiDetails,
            docLinks
          });
        }
    }
  });
};
exports.createGetApiDeprecations = createGetApiDeprecations;
const registerApiDeprecationsInfo = ({
  deprecationsFactory,
  http,
  coreUsageData,
  docLinks
}) => {
  const deprecationsRegistery = deprecationsFactory.getRegistry('core.api_deprecations');
  deprecationsRegistery.registerDeprecations({
    getDeprecations: createGetApiDeprecations({
      http,
      coreUsageData,
      docLinks
    })
  });
};
exports.registerApiDeprecationsInfo = registerApiDeprecationsInfo;