"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoRefreshControls = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _time_duration = require("../../../lib/time_duration");
var _i18n2 = require("../../../../i18n");
var _custom_interval = require("./custom_interval");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  time: timeStrings
} = _i18n2.UnitStrings;
const {
  getSecondsText,
  getMinutesText,
  getHoursText
} = timeStrings;
const strings = {
  getDisableTooltip: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderAutoRefreshControls.disableTooltip', {
    defaultMessage: 'Disable auto-refresh'
  }),
  getIntervalFormLabelText: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderAutoRefreshControls.intervalFormLabel', {
    defaultMessage: 'Change auto-refresh interval'
  }),
  getRefreshListDurationManualText: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderAutoRefreshControls.refreshListDurationManualText', {
    defaultMessage: 'Manually'
  }),
  getRefreshListTitle: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderAutoRefreshControls.refreshListTitle', {
    defaultMessage: 'Refresh elements'
  })
};
const ListGroup = ({
  children,
  ...rest
}) => /*#__PURE__*/_react.default.createElement("ul", (0, _extends2.default)({
  style: {
    listStyle: 'none',
    margin: 0
  }
}, rest), [children]);
const generateId = (0, _eui.htmlIdGenerator)();
const AutoRefreshControls = ({
  refreshInterval,
  setRefresh,
  disableInterval
}) => {
  const RefreshItem = ({
    duration,
    label,
    descriptionId
  }) => /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => setRefresh(duration),
    "aria-describedby": descriptionId
  }, label));
  const interval = (0, _time_duration.timeDuration)(refreshInterval);
  const intervalTitleId = generateId();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "spaceBetween",
    className: "canvasViewMenu__kioskSettings"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceAround",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, strings.getRefreshListTitle()), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, refreshInterval > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, timeStrings.getCycleTimeText(interval.length, interval.format)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, strings.getRefreshListDurationManualText())))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "xs"
  }, refreshInterval > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "bottom",
    content: strings.getDisableTooltip(),
    disableScreenReaderOutput: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    onClick: disableInterval,
    "aria-label": strings.getDisableTooltip()
  }))) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    id: intervalTitleId
  }, /*#__PURE__*/_react.default.createElement("p", null, strings.getIntervalFormLabelText())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(ListGroup, {
    "aria-labelledby": intervalTitleId,
    className: "canvasControlSettings__list"
  }, /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 30000,
    label: getSecondsText(30),
    descriptionId: intervalTitleId
  }), /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 60000,
    label: getMinutesText(1),
    descriptionId: intervalTitleId
  }), /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 300000,
    label: getMinutesText(5),
    descriptionId: intervalTitleId
  }), /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 1800000,
    label: getMinutesText(30),
    descriptionId: intervalTitleId
  }), /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 3600000,
    label: getHoursText(1),
    descriptionId: intervalTitleId
  }), /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 43200000,
    label: getHoursText(12),
    descriptionId: intervalTitleId
  }), /*#__PURE__*/_react.default.createElement(RefreshItem, {
    duration: 86400000,
    label: getHoursText(24),
    descriptionId: intervalTitleId
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_custom_interval.CustomInterval, {
    onSubmit: value => setRefresh(value)
  })));
};
exports.AutoRefreshControls = AutoRefreshControls;
AutoRefreshControls.propTypes = {
  refreshInterval: _propTypes.default.number,
  setRefresh: _propTypes.default.func.isRequired,
  disableInterval: _propTypes.default.func.isRequired
};