"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditVar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _var_value_field = require("./var_value_field");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const strings = {
  getAddTitle: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.addTitleLabel', {
    defaultMessage: 'Add variable'
  }),
  getCancelButtonLabel: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }),
  getDuplicateNameError: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.duplicateNameError', {
    defaultMessage: 'Variable name already in use'
  }),
  getEditTitle: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.editTitleLabel', {
    defaultMessage: 'Edit variable'
  }),
  getEditWarning: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.editWarning', {
    defaultMessage: 'Editing a variable in use may adversely affect your workpad'
  }),
  getNameFieldLabel: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.nameFieldLabel', {
    defaultMessage: 'Name'
  }),
  getSaveButtonLabel: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.saveButtonLabel', {
    defaultMessage: 'Save changes'
  }),
  getTypeBooleanLabel: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.typeBooleanLabel', {
    defaultMessage: 'Boolean'
  }),
  getTypeFieldLabel: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.typeFieldLabel', {
    defaultMessage: 'Type'
  }),
  getTypeNumberLabel: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.typeNumberLabel', {
    defaultMessage: 'Number'
  }),
  getTypeStringLabel: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.typeStringLabel', {
    defaultMessage: 'String'
  }),
  getValueFieldLabel: () => _i18n.i18n.translate('xpack.canvas.varConfigEditVar.valueFieldLabel', {
    defaultMessage: 'Value'
  })
};
const checkDupeName = (newName, oldName, variables) => {
  const match = variables.find(v => {
    // If the new name matches an existing variable and that
    // matched variable name isn't the old name, then there
    // is a duplicate
    return newName === v.name && (!oldName || v.name !== oldName);
  });
  return !!match;
};
const EditVar = ({
  variables,
  selectedVar,
  onCancel,
  onSave
}) => {
  // If there isn't a selected variable, we're creating a new var
  const isNew = selectedVar === null;
  const [type, setType] = (0, _react.useState)(isNew ? 'string' : selectedVar.type);
  const [name, setName] = (0, _react.useState)(isNew ? '' : selectedVar.name);
  const [value, setValue] = (0, _react.useState)(isNew ? '' : selectedVar.value);
  const hasDupeName = checkDupeName(name, selectedVar && selectedVar.name, variables);
  const hasEmptyValue = value.toString().trim() === '';
  const hasEmptyName = !name;
  const typeOptions = [{
    value: 'string',
    inputDisplay: /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasEditVar__typeOption"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
      iconType: "tokenString",
      className: "canvasEditVar__tokenIcon"
    }), ' ', /*#__PURE__*/_react.default.createElement("span", null, strings.getTypeStringLabel()))
  }, {
    value: 'number',
    inputDisplay: /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasEditVar__typeOption"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
      iconType: "tokenNumber",
      className: "canvasEditVar__tokenIcon"
    }), ' ', /*#__PURE__*/_react.default.createElement("span", null, strings.getTypeNumberLabel()))
  }, {
    value: 'boolean',
    inputDisplay: /*#__PURE__*/_react.default.createElement("div", {
      className: "canvasEditVar__typeOption"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
      iconType: "tokenBoolean",
      className: "canvasEditVar__tokenIcon"
    }), ' ', /*#__PURE__*/_react.default.createElement("span", null, strings.getTypeBooleanLabel()))
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasVarHeader__triggerWrapper"
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "canvasVarHeader__button",
    type: "button",
    onClick: () => onCancel()
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "canvasVarHeader__iconWrapper"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "sortLeft",
    style: {
      verticalAlign: 'top'
    }
  })), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement("span", {
    className: "canvasVarHeader__anchor"
  }, isNew ? strings.getAddTitle() : strings.getEditTitle())))), /*#__PURE__*/_react.default.createElement("div", {
    className: "canvasSidebar__accordionContent"
  }, !isNew && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: strings.getEditWarning(),
    color: "warning",
    iconType: "warning",
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getTypeFieldLabel(),
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: typeOptions,
    valueOfSelected: type,
    onChange: v => {
      // Only have these types possible in the dropdown
      setType(v);

      // Reset default value
      if (v === 'boolean') {
        // Just setting a default value
        setValue(true);
      } else if (v === 'number') {
        // Setting default number
        setValue(0);
      } else {
        setValue('');
      }
    },
    compressed: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getNameFieldLabel(),
    display: "rowCompressed",
    isInvalid: hasDupeName,
    error: hasDupeName && strings.getDuplicateNameError()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "name",
    value: name,
    compressed: true,
    onChange: e => setName(e.target.value),
    isInvalid: hasDupeName
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getValueFieldLabel(),
    display: "rowCompressed"
  }, /*#__PURE__*/_react.default.createElement(_var_value_field.VarValueField, {
    type: type,
    value: value,
    onChange: v => setValue(v)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    fill: true,
    onClick: () => onSave({
      name,
      value,
      type
    }),
    disabled: hasDupeName || hasEmptyValue || hasEmptyName,
    iconType: "save"
  }, strings.getSaveButtonLabel())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: () => onCancel()
  }, strings.getCancelButtonLabel()))))));
};
exports.EditVar = EditVar;