"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkUpdateAlertSummary = void 0;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _elasticAssistant = require("@kbn/elastic-assistant");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBulkUpdateAlertSummary = () => {
  const {
    http,
    toasts
  } = (0, _elasticAssistant.useAssistantContext)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const abortController = (0, _react.useRef)(new AbortController());
  const bulkUpdate = (0, _react.useCallback)(async ({
    alertSummary
  }) => {
    setIsLoading(true);
    try {
      return await bulkUpdateAlertSummary({
        http,
        alertSummary,
        toasts,
        signal: abortController.current.signal
      });
    } catch (error) {
      toasts === null || toasts === void 0 ? void 0 : toasts.addDanger(_i18n.i18n.translate('xpack.securitySolution.alertSummary.bulkActionsError', {
        defaultMessage: 'Failed to update alert summaries: {error}',
        values: {
          error: error instanceof Error ? error.message : String(error)
        }
      }));
    } finally {
      setIsLoading(false);
    }
  }, [http, toasts]);
  const cancelRequest = (0, _react.useCallback)(() => {
    abortController.current.abort();
    abortController.current = new AbortController();
  }, []);
  return {
    isLoading,
    bulkUpdate,
    abortStream: cancelRequest
  };
};
exports.useBulkUpdateAlertSummary = useBulkUpdateAlertSummary;
const bulkUpdateAlertSummary = async ({
  alertSummary,
  http,
  signal
}) => {
  const result = await http.fetch(_elasticAssistantCommon.ELASTIC_AI_ASSISTANT_ALERT_SUMMARY_URL_BULK_ACTION, {
    method: 'POST',
    version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
    body: JSON.stringify(alertSummary),
    signal
  });
  if (!result.success) {
    var _result$attributes$er;
    const serverError = (_result$attributes$er = result.attributes.errors) === null || _result$attributes$er === void 0 ? void 0 : _result$attributes$er.map(e => `${e.status_code ? `Error code: ${e.status_code}. ` : ''}Error message: ${e.message} for alert summaries ${e.alert_summaries.map(c => c.id).join(', ')}`).join(',\n');
    throw new Error(serverError);
  }
  return result;
};