"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userAssetTableLocalStorageMiddleware = void 0;
var _fp = require("lodash/fp");
var _ = require(".");
var _selectors = require("./selectors");
var _storage = require("./storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  removeUserAssetTableField,
  addUserAssetTableField
} = _.usersActions;
const tableActionTypes = new Set([removeUserAssetTableField.type, addUserAssetTableField.type]);
const userAssetTableLocalStorageMiddleware = storage => store => next => action => {
  // perform the action
  const ret = next(action);

  // persist the table state when a table action has been performed
  if (tableActionTypes.has(action.type)) {
    const tableById = (0, _selectors.selectUserAssetTables)(store.getState());
    const tableId = (0, _fp.get)('payload.tableId', action);
    if (tableById && tableById[tableId] && storage) {
      if (tableActionTypes.has(action.type)) {
        (0, _storage.persistUserAssetTableInStorage)(storage, tableId, tableById[tableId]);
      }
    }
  }
  return ret;
};
exports.userAssetTableLocalStorageMiddleware = userAssetTableLocalStorageMiddleware;