"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsFieldInIndexPattern = void 0;
var _react = require("react");
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _map_config = require("../../network/components/embeddables/map_config");
var _kibana = require("../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIsFieldInIndexPattern = () => {
  const {
    dataViews
  } = (0, _kibana.useKibana)().services.data;
  return (0, _react.useMemo)(() => (0, _memoizeOne.default)(async pattern => {
    const fieldsList = (0, _map_config.getRequiredMapsFields)(pattern);
    const fields = await dataViews.getFieldsForWildcard({
      pattern,
      fields: fieldsList
    });
    const fieldNames = fields.map(f => f.name);
    return fieldsList.every(field => fieldNames.includes(field));
  }, (newArgs, lastArgs) => newArgs[0] === lastArgs[0]), [dataViews]);
};
exports.useIsFieldInIndexPattern = useIsFieldInIndexPattern;