"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationCards = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/fleet-plugin/public");
var _constants = require("../../../../common/lib/integrations/constants");
var _use_integration_link_state = require("../../../../common/hooks/integrations/use_integration_link_state");
var _integrations = require("../../../../common/utils/integrations");
var _constants2 = require("../../../../../common/constants");
var _kibana = require("../../../../common/lib/kibana");
var _use_integrations = require("../hooks/use_integrations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This component has to be wrapped by react Suspense.
 * It suspends while loading the lazy package card and while fetching the integrations.
 */
const IntegrationCards = () => {
  const state = (0, _use_integration_link_state.useIntegrationLinkState)(_constants2.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH);
  const {
    navigateTo
  } = (0, _kibana.useNavigation)();
  const integrations = (0, _use_integrations.useEntityAnalyticsIntegrations)();
  const navigateToIntegration = (0, _react.useCallback)((id, version) => {
    navigateTo({
      appId: _constants.INTEGRATION_APP_ID,
      path: (0, _integrations.addPathParamToUrl)(`/detail/${id}-${version}/overview`, _constants2.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH),
      state
    });
  }, [navigateTo, state]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween"
  }, integrations.map(({
    name,
    title,
    icons,
    description,
    version
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    key: name,
    "data-test-subj": "entity_analytics-integration-card"
  }, /*#__PURE__*/_react.default.createElement(_public.LazyPackageCard, {
    description: description !== null && description !== void 0 ? description : '',
    icons: icons !== null && icons !== void 0 ? icons : [],
    id: name,
    name: name,
    title: title,
    version: version,
    onCardClick: () => {
      navigateToIntegration(name, version);
    }
    // Required values that don't make sense for this scenario
    ,
    categories: [],
    integration: '',
    url: ''
  }))));
};
exports.IntegrationCards = IntegrationCards;