"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupStatsRenderer = exports.getIntegrationComponent = exports.TABLE_GROUP_STATS_TEST_ID = exports.IntegrationIcon = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _integration_icon = require("../common/integration_icon");
var _table_section_context = require("./table_section_context");
var _grouping_settings = require("../../alerts_table/grouping_settings");
var _alerts_grouping = require("../../alerts_table/alerts_grouping");
var _use_get_integration_from_rule_id = require("../../../hooks/alert_summary/use_get_integration_from_rule_id");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const STATS_GROUP_SIGNAL_RULE_ID = _i18n.i18n.translate('xpack.securitySolution.alertSummary.groups.integrations', {
  defaultMessage: 'Integrations:'
});
const STATS_GROUP_SIGNAL_RULE_ID_MULTI = _i18n.i18n.translate('xpack.securitySolution.alertSummary.groups.integrations.multi', {
  defaultMessage: ' Multi'
});
const TABLE_GROUP_STATS_TEST_ID = exports.TABLE_GROUP_STATS_TEST_ID = 'ai-for-soc-alert-table-group-stats';
/**
 * Renders the icon for the integration that matches the rule id.
 * In AI for SOC, we can retrieve the integration/package that matches a specific rule, via the related_integrations field on the rule.
 */
const IntegrationIcon = exports.IntegrationIcon = /*#__PURE__*/(0, _react.memo)(({
  ruleId
}) => {
  const {
    packages,
    ruleResponse
  } = (0, _table_section_context.useTableSectionContext)();
  const {
    integration
  } = (0, _use_get_integration_from_rule_id.useGetIntegrationFromRuleId)({
    packages,
    rules: ruleResponse.rules,
    ruleId
  });
  return /*#__PURE__*/_react.default.createElement(_integration_icon.IntegrationIcon, {
    "data-test-subj": TABLE_GROUP_STATS_TEST_ID,
    integration: integration
  });
});
IntegrationIcon.displayName = 'IntegrationIcon';

/**
 * Return a renderer for integration aggregation.
 */
const getIntegrationComponent = bucket => {
  var _bucket$signalRuleIdS;
  const signalRuleIds = (_bucket$signalRuleIdS = bucket.signalRuleIdSubAggregation) === null || _bucket$signalRuleIdS === void 0 ? void 0 : _bucket$signalRuleIdS.buckets;
  if (!signalRuleIds || signalRuleIds.length === 0) {
    return [];
  }
  if (signalRuleIds.length === 1) {
    const ruleId = Array.isArray(signalRuleIds[0].key) ? signalRuleIds[0].key[0] : signalRuleIds[0].key;
    return [{
      title: STATS_GROUP_SIGNAL_RULE_ID,
      component: /*#__PURE__*/_react.default.createElement(IntegrationIcon, {
        ruleId: ruleId
      })
    }];
  }
  return [{
    title: STATS_GROUP_SIGNAL_RULE_ID,
    component: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, STATS_GROUP_SIGNAL_RULE_ID_MULTI)
  }];
};

/**
 * Returns stats to be used in the`extraAction` property of the EuiAccordion component used within the kbn-grouping package.
 * It handles custom renders for the following fields:
 * - signal.rule.rule_id
 * - kibana.alert.severity
 * - kibana.alert.rule.name
 * And returns a default view for all the other fields.
 *
 * These go hand in hand with groupingOptions, groupTitleRenderers and groupStatsAggregations.
 */
exports.getIntegrationComponent = getIntegrationComponent;
const groupStatsRenderer = (selectedGroup, bucket) => {
  const defaultBadges = (0, _alerts_grouping.DEFAULT_GROUP_STATS_RENDERER)(selectedGroup, bucket);
  const severityComponent = (0, _grouping_settings.getSeverityComponent)(bucket);
  const integrationComponent = getIntegrationComponent(bucket);
  const rulesBadge = (0, _grouping_settings.getRulesBadge)(bucket);
  switch (selectedGroup) {
    case 'signal.rule.rule_id':
      return [...severityComponent, rulesBadge, ...defaultBadges];
    case 'kibana.alert.severity':
      return [...integrationComponent, rulesBadge, ...defaultBadges];
    case 'kibana.alert.rule.name':
      return [...integrationComponent, ...severityComponent, ...defaultBadges];
    default:
      return [...integrationComponent, ...severityComponent, rulesBadge, ...defaultBadges];
  }
};
exports.groupStatsRenderer = groupStatsRenderer;