"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfoPopoverBody = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _react2 = _interopRequireWildcard(require("react"));
var _last_times_popover = require("../countdown/last_times_popover");
var _helpers = require("../countdown/last_times_popover/helpers");
var _translations = require("../countdown/last_times_popover/translations");
var _translations2 = require("../countdown/translations");
var _use_kibana_feature_flags = require("../../use_kibana_feature_flags");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TEXT_COLOR = '#343741';
const InfoPopoverBodyComponent = ({
  averageSuccessfulDurationNanoseconds,
  connectorIntervals,
  successfulGenerations
}) => {
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();
  const {
    attackDiscoveryAlertsEnabled
  } = (0, _use_kibana_feature_flags.useKibanaFeatureFlags)();
  const averageIntervalSeconds = (0, _react2.useMemo)(() => {
    if (attackDiscoveryAlertsEnabled) {
      return averageSuccessfulDurationNanoseconds != null ? Math.ceil(averageSuccessfulDurationNanoseconds / 1_000_000_000) : 0;
    } else {
      return (0, _helpers.getAverageIntervalSeconds)(connectorIntervals);
    }
  }, [attackDiscoveryAlertsEnabled, averageSuccessfulDurationNanoseconds, connectorIntervals]);
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    css: (0, _react.css)`
                display: inline-block;
                max-width: ${_helpers.MAX_SECONDS_BADGE_WIDTH}px;
              `,
    color: "hollow",
    "data-test-subj": "averageTimeBadge",
    iconType: "clock"
  }, /*#__PURE__*/_react2.default.createElement("span", null, averageIntervalSeconds, _translations.SECONDS_ABBREVIATION))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: isDarkMode ? 'default' : TEXT_COLOR,
    css: (0, _react.css)`
                font-weight: 400;
              `,
    "data-test-subj": "averageTimeIsCalculated",
    size: "s"
  }, /*#__PURE__*/_react2.default.createElement("span", null, _translations2.AVERAGE_TIME))))), /*#__PURE__*/_react2.default.createElement(_last_times_popover.LastTimesPopover, {
    connectorIntervals: connectorIntervals,
    successfulGenerations: successfulGenerations
  }));
};
InfoPopoverBodyComponent.displayName = 'InfoPopoverBody';
const InfoPopoverBody = exports.InfoPopoverBody = /*#__PURE__*/_react2.default.memo(InfoPopoverBodyComponent);