"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgentlessCredentialsType = exports.ReadDocumentation = exports.AwsCredentialsForm = exports.AwsCredentialTypeSelector = exports.AWSSetupInfoContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _utils = require("../utils");
var _asset_boxed_radio_group = require("../asset_boxed_radio_group");
var _test_subjects = require("../test_subjects");
var _constants = require("./constants");
var _aws_credentials_form_options = require("./aws_credentials_form_options");
var _aws_input_var_fields = require("./aws_input_var_fields");
var _hooks = require("./hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AWSSetupInfoContent = ({
  info
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.awsIntegration.setupInfoContentTitle",
    defaultMessage: "Setup Access"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, info));
};
exports.AWSSetupInfoContent = AWSSetupInfoContent;
const getSetupFormatOptions = () => [{
  id: _constants.AWS_SETUP_FORMAT.CLOUD_FORMATION,
  label: 'CloudFormation',
  testId: _test_subjects.AWS_CREDENTIALS_TYPE_OPTIONS_TEST_SUBJ.CLOUDFORMATION
}, {
  id: _constants.AWS_SETUP_FORMAT.MANUAL,
  label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.awsIntegration.setupFormatOptions.manual', {
    defaultMessage: 'Manual'
  }),
  testId: _test_subjects.AWS_CREDENTIALS_TYPE_OPTIONS_TEST_SUBJ.MANUAL
}];
const getAgentlessCredentialsType = (postureInput, showCloudConnectors) => {
  const credentialsType = (0, _utils.getAwsCredentialsType)(postureInput);
  if (!credentialsType && showCloudConnectors || credentialsType === _constants.AWS_CREDENTIALS_TYPE.CLOUD_FORMATION && showCloudConnectors) {
    return _constants.AWS_CREDENTIALS_TYPE.CLOUD_CONNECTORS;
  }
  if (credentialsType === _constants.AWS_CREDENTIALS_TYPE.CLOUD_FORMATION || !credentialsType) {
    return _constants.AWS_CREDENTIALS_TYPE.DIRECT_ACCESS_KEYS;
  }
  return credentialsType;
};
exports.getAgentlessCredentialsType = getAgentlessCredentialsType;
const CloudFormationSetup = ({
  hasCloudFormationTemplate,
  input
}) => {
  var _input$streams, _input$streams$, _input$streams$$vars, _input$streams$$vars$;
  if (!hasCloudFormationTemplate) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.fleetIntegration.awsIntegration.cloudFormationSetupStep.notSupported",
      defaultMessage: "CloudFormation is not supported on the current Integration version, please upgrade your integration to the latest version to use CloudFormation"
    }));
  }
  const accountType = (_input$streams = input.streams) === null || _input$streams === void 0 ? void 0 : (_input$streams$ = _input$streams[0]) === null || _input$streams$ === void 0 ? void 0 : (_input$streams$$vars = _input$streams$.vars) === null || _input$streams$$vars === void 0 ? void 0 : (_input$streams$$vars$ = _input$streams$$vars['aws.account_type']) === null || _input$streams$$vars$ === void 0 ? void 0 : _input$streams$$vars$.value;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("ol", {
    css: (0, _react2.css)`
            list-style: auto;
          `
  }, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.awsIntegration.cloudFormationSetupStep.hostRequirement",
    defaultMessage: "Ensure \"New hosts\" is selected in the \"Where to add this integration?\" section below"
  })), accountType === _constants.AWS_ORGANIZATION_ACCOUNT ? /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.awsIntegration.cloudFormationSetupStep.organizationLogin",
    defaultMessage: "Log in as an admin in your organization's AWS management account"
  })) : /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.awsIntegration.cloudFormationSetupStep.login",
    defaultMessage: "Log in as an admin to the AWS Account you want to onboard"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.awsIntegration.cloudFormationSetupStep.save",
    defaultMessage: "Click the Save and continue button on the bottom right of this page"
  })), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.awsIntegration.cloudFormationSetupStep.launch",
    defaultMessage: "On the subsequent pop-up modal, click the Launch CloudFormation button."
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(ReadDocumentation, {
    url: CLOUD_FORMATION_EXTERNAL_DOC_URL
  }));
};
const CLOUD_FORMATION_EXTERNAL_DOC_URL = 'https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-whatis-howdoesitwork.html';
const Link = ({
  children,
  url
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: url,
  target: "_blank",
  rel: "noopener nofollow noreferrer",
  "data-test-subj": "externalLink"
}, children);
const ReadDocumentation = ({
  url
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.assetInventory.fleetIntegration.awsIntegration.cloudFormationSetupNote",
    defaultMessage: "Read the {documentation} for more details",
    values: {
      documentation: /*#__PURE__*/_react.default.createElement(Link, {
        url: url
      }, _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.documentationLinkText', {
        defaultMessage: 'documentation'
      }))
    }
  }));
};
exports.ReadDocumentation = ReadDocumentation;
const AwsCredentialsForm = ({
  input,
  newPolicy,
  updatePolicy,
  packageInfo,
  disabled = false,
  hasInvalidRequiredVars
}) => {
  const {
    awsCredentialsType,
    setupFormat,
    group,
    fields,
    elasticDocLink,
    hasCloudFormationTemplate,
    onSetupFormatChange
  } = (0, _hooks.useAwsCredentialsForm)({
    newPolicy,
    input,
    packageInfo,
    updatePolicy
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AWSSetupInfoContent, {
    info: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.assetInventory.fleetIntegration.gettingStarted.setupInfoContent",
      defaultMessage: "Utilize AWS CloudFormation (a built-in AWS tool) or a series of manual steps to set up and deploy Cloud Asset Discovery for assessing your AWS environment's assets. Refer to our {gettingStartedLink} guide for details.",
      values: {
        gettingStartedLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: elasticDocLink,
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.assetInventory.fleetIntegration.gettingStarted.setupInfoContentLink",
          defaultMessage: "Getting Started"
        }))
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_asset_boxed_radio_group.RadioGroup, {
    disabled: disabled,
    size: "m",
    options: getSetupFormatOptions(),
    idSelected: setupFormat,
    onChange: selectedSetupFormat => selectedSetupFormat !== setupFormat && onSetupFormatChange(selectedSetupFormat),
    name: "setupFormat"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), setupFormat === _constants.AWS_SETUP_FORMAT.CLOUD_FORMATION && /*#__PURE__*/_react.default.createElement(CloudFormationSetup, {
    hasCloudFormationTemplate: hasCloudFormationTemplate,
    input: input
  }), setupFormat === _constants.AWS_SETUP_FORMAT.MANUAL && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AwsCredentialTypeSelector, {
    disabled: disabled,
    label: _i18n.i18n.translate('xpack.securitySolution.assetInventory.fleetIntegration.awsCredentialTypeSelectorLabel', {
      defaultMessage: 'Preferred manual method'
    }),
    options: (0, _aws_credentials_form_options.getAwsCredentialsFormManualOptions)(),
    type: awsCredentialsType,
    onChange: optionId => {
      updatePolicy((0, _utils.getAssetPolicy)(newPolicy, input.type, {
        'aws.credentials.type': {
          value: optionId
        }
      }));
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), group.info, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(ReadDocumentation, {
    url: elasticDocLink
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_aws_input_var_fields.AwsInputVarFields, {
    fields: fields,
    packageInfo: packageInfo,
    onChange: (key, value) => {
      updatePolicy((0, _utils.getAssetPolicy)(newPolicy, input.type, {
        [key]: {
          value
        }
      }));
    },
    hasInvalidRequiredVars: hasInvalidRequiredVars
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.AwsCredentialsForm = AwsCredentialsForm;
const AwsCredentialTypeSelector = ({
  type,
  onChange,
  label,
  options,
  disabled = false
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  fullWidth: true,
  label: label
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
  fullWidth: true,
  options: options,
  value: type,
  disabled: disabled,
  onChange: optionElem => {
    onChange(optionElem.target.value);
  },
  "data-test-subj": _test_subjects.AWS_CREDENTIALS_TYPE_SELECTOR_TEST_SUBJ
}));
exports.AwsCredentialTypeSelector = AwsCredentialTypeSelector;