"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryConfigProvider = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TelemetryConfigProvider {
  constructor() {
    (0, _defineProperty2.default)(this, "isOptedIn$", void 0);
    (0, _defineProperty2.default)(this, "_isOptedIn", void 0);
    (0, _defineProperty2.default)(this, "subscription", void 0);
  }
  start(isOptedIn$) {
    this.isOptedIn$ = isOptedIn$;
    this.subscription = this.isOptedIn$.subscribe(isOptedIn => {
      this._isOptedIn = isOptedIn;
    });
  }
  stop() {
    var _this$subscription;
    (_this$subscription = this.subscription) === null || _this$subscription === void 0 ? void 0 : _this$subscription.unsubscribe();
  }
  getIsOptedIn() {
    return this._isOptedIn;
  }
  getObservable() {
    return this.isOptedIn$;
  }
}
exports.TelemetryConfigProvider = TelemetryConfigProvider;