"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdateWorkflowInsightResponse = exports.UpdateWorkflowInsightRequestParams = exports.UpdateWorkflowInsightRequestBody = exports.GetWorkflowInsightsResponse = exports.GetWorkflowInsightsRequestQuery = void 0;
var _zod = require("@kbn/zod");
var _zodHelpers = require("@kbn/zod-helpers");
var _common = require("../model/schema/common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Workflow Insights API
 *   version: 1
 */

const GetWorkflowInsightsRequestQuery = exports.GetWorkflowInsightsRequestQuery = _zod.z.object({
  size: _zod.z.coerce.number().int().optional(),
  from: _zod.z.coerce.number().int().optional(),
  ids: (0, _zodHelpers.ArrayFromString)(_zod.z.string()).optional(),
  categories: (0, _zodHelpers.ArrayFromString)(_zod.z.literal('endpoint')).optional(),
  types: (0, _zodHelpers.ArrayFromString)(_zod.z.enum(['incompatible_antivirus', 'noisy_process_tree'])).optional(),
  sourceTypes: (0, _zodHelpers.ArrayFromString)(_zod.z.literal('llm-connector')).optional(),
  sourceIds: (0, _zodHelpers.ArrayFromString)(_zod.z.string()).optional(),
  targetTypes: (0, _zodHelpers.ArrayFromString)(_zod.z.literal('endpoint')).optional(),
  targetIds: (0, _zodHelpers.ArrayFromString)(_zod.z.string()).optional(),
  actionTypes: (0, _zodHelpers.ArrayFromString)(_zod.z.enum(['refreshed', 'remediated', 'suppressed', 'dismissed']))
});
const GetWorkflowInsightsResponse = exports.GetWorkflowInsightsResponse = _common.SuccessResponse;
const UpdateWorkflowInsightRequestParams = exports.UpdateWorkflowInsightRequestParams = _zod.z.object({
  insightId: _zod.z.string().min(1)
});
const UpdateWorkflowInsightRequestBody = exports.UpdateWorkflowInsightRequestBody = _zod.z.object({
  '@timestamp': _zod.z.string().optional(),
  message: _zod.z.string().optional(),
  category: _zod.z.literal('endpoint').optional(),
  type: _zod.z.enum(['incompatible_antivirus', 'noisy_process_tree']).optional(),
  source: _zod.z.object({
    type: _zod.z.literal('llm-connector').optional(),
    id: _zod.z.string().optional(),
    data_range_start: _zod.z.string().optional(),
    data_range_end: _zod.z.string().optional()
  }).optional(),
  target: _zod.z.object({
    type: _zod.z.literal('endpoint').optional(),
    ids: _zod.z.array(_zod.z.string()).optional()
  }).optional(),
  action: _zod.z.object({
    type: _zod.z.enum(['refreshed', 'remediated', 'suppressed', 'dismissed']).optional(),
    timestamp: _zod.z.string().optional()
  }).optional(),
  value: _zod.z.string().optional(),
  remediation: _zod.z.object({
    exception_list_items: _zod.z.array(_zod.z.object({
      list_id: _zod.z.string().optional(),
      name: _zod.z.string().optional(),
      description: _zod.z.string().optional(),
      entries: _zod.z.array(_zod.z.unknown()).optional(),
      tags: _zod.z.array(_zod.z.string()).optional(),
      os_types: _zod.z.array(_zod.z.string()).optional()
    })).optional()
  }).optional(),
  metadata: _zod.z.object({
    notes: _zod.z.object({}).catchall(_zod.z.string()).optional(),
    message_variables: _zod.z.array(_zod.z.string()).optional()
  }).optional()
});
const UpdateWorkflowInsightResponse = exports.UpdateWorkflowInsightResponse = _common.SuccessResponse;